/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.dmn;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.ast.InputDataNodeImpl;
import org.kie.dmn.core.ast.ItemDefNodeImpl;
import org.kie.dmn.core.internal.utils.DMNEvaluationUtils;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.dmn.DMNContextKS;
import org.kie.server.api.model.dmn.DMNDecisionInfo;
import org.kie.server.api.model.dmn.DMNDecisionServiceInfo;
import org.kie.server.api.model.dmn.DMNInputDataInfo;
import org.kie.server.api.model.dmn.DMNItemDefinitionInfo;
import org.kie.server.api.model.dmn.DMNModelInfo;
import org.kie.server.api.model.dmn.DMNModelInfoList;
import org.kie.server.api.model.dmn.DMNQNameInfo;
import org.kie.server.api.model.dmn.DMNResultKS;
import org.kie.server.api.model.dmn.DMNUnaryTestsInfo;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.prometheus.PrometheusKieServerExtension;
import org.kie.server.services.prometheus.PrometheusMetricsDMNListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelEvaluatorServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(ModelEvaluatorServiceBase.class);
    private KieServerRegistry context;
    private MarshallerHelper marshallerHelper;

    public ModelEvaluatorServiceBase(KieServerRegistry context) {
        this.context = context;
        this.marshallerHelper = new MarshallerHelper(context);
    }

    public ServiceResponse<DMNModelInfoList> getModels(String containerId) {
        try {
            KieContainerInstanceImpl kContainer = this.context.getContainer(containerId, ContainerLocatorProvider.get().getLocator());
            DMNRuntime kieRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kContainer.getKieContainer().getKieBase()).get(DMNRuntime.class);
            List models = kieRuntime.getModels();
            List result = models.stream().map(ModelEvaluatorServiceBase::modelToInfo).collect(Collectors.toList());
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "OK models successfully retrieved from container '" + containerId + "'", (Object)new DMNModelInfoList(result));
        }
        catch (Exception e) {
            LOG.error("Error retrieving models from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error retrieving models from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    public static DMNModelInfo modelToInfo(DMNModel model) {
        DMNModelInfo res = new DMNModelInfo();
        res.setNamespace(model.getNamespace());
        res.setName(model.getName());
        res.setId(model.getDefinitions().getId());
        res.setDecisions((Collection)model.getDecisions().stream().map(ModelEvaluatorServiceBase::decisionToInfo).collect(Collectors.toSet()));
        res.setDecisionServices((Collection)model.getDecisionServices().stream().map(ModelEvaluatorServiceBase::decisionServiceToInfo).collect(Collectors.toSet()));
        res.setInputs((Collection)model.getInputs().stream().map(ModelEvaluatorServiceBase::inputDataToInfo).collect(Collectors.toSet()));
        res.setItemDefinitions((Collection)model.getItemDefinitions().stream().map(id -> ModelEvaluatorServiceBase.itemDefinitionToInfo(((ItemDefNodeImpl)id).getItemDef())).collect(Collectors.toSet()));
        return res;
    }

    public static DMNDecisionServiceInfo decisionServiceToInfo(DecisionServiceNode dsNode) {
        DMNDecisionServiceInfo res = new DMNDecisionServiceInfo();
        res.setName(dsNode.getName());
        res.setId(dsNode.getId());
        return res;
    }

    public static DMNDecisionInfo decisionToInfo(DecisionNode decisionNode) {
        DMNDecisionInfo res = new DMNDecisionInfo();
        res.setName(decisionNode.getName());
        res.setId(decisionNode.getId());
        return res;
    }

    public static DMNInputDataInfo inputDataToInfo(InputDataNode inputDataNode) {
        DMNInputDataInfo res = new DMNInputDataInfo();
        res.setName(inputDataNode.getName());
        res.setId(inputDataNode.getId());
        InputData id = ((InputDataNodeImpl)inputDataNode).getInputData();
        QName typeRef = id.getVariable().getTypeRef();
        if (typeRef != null) {
            if ("".equals(typeRef.getNamespaceURI())) {
                String actualNS = id.getNamespaceURI(typeRef.getPrefix());
                typeRef = new QName(actualNS, typeRef.getLocalPart(), typeRef.getPrefix());
            }
            res.setTypeRef(DMNQNameInfo.of((QName)typeRef));
        }
        return res;
    }

    public static DMNItemDefinitionInfo itemDefinitionToInfo(ItemDefinition itemDef) {
        DMNItemDefinitionInfo res = new DMNItemDefinitionInfo();
        res.setId(itemDef.getId());
        res.setName(itemDef.getName());
        if (itemDef.getTypeRef() != null) {
            res.setTypeRef(DMNQNameInfo.of((QName)itemDef.getTypeRef()));
        }
        if (itemDef.getAllowedValues() != null) {
            DMNUnaryTestsInfo av = new DMNUnaryTestsInfo();
            av.setText(itemDef.getAllowedValues().getText());
            av.setExpressionLanguage(itemDef.getAllowedValues().getExpressionLanguage());
            res.setAllowedValues(av);
        }
        if (itemDef.getItemComponent() != null && !itemDef.getItemComponent().isEmpty()) {
            List components = itemDef.getItemComponent().stream().map(ModelEvaluatorServiceBase::itemDefinitionToInfo).collect(Collectors.toList());
            res.setItemComponent(components);
        }
        res.setTypeLanguage(itemDef.getTypeLanguage());
        res.setIsCollection(Boolean.valueOf(itemDef.isIsCollection()));
        return res;
    }

    public ServiceResponse<DMNResultKS> evaluateDecisions(String containerId, String contextPayload, String marshallingType) {
        try {
            KieContainerInstanceImpl kContainer = this.context.getContainer(containerId, ContainerLocatorProvider.get().getLocator());
            DMNRuntime dmnRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kContainer.getKieContainer().getKieBase()).get(DMNRuntime.class);
            PrometheusKieServerExtension extension = (PrometheusKieServerExtension)this.context.getServerExtension("Prometheus");
            if (extension != null) {
                PrometheusMetricsDMNListener listener = new PrometheusMetricsDMNListener(PrometheusKieServerExtension.getMetrics(), (KieContainerInstance)kContainer);
                dmnRuntime.addListener((DMNRuntimeEventListener)listener);
                List listeners = extension.getDMNRuntimeListeners((KieContainerInstance)kContainer);
                listeners.forEach(l -> {
                    if (!dmnRuntime.getListeners().contains(l)) {
                        dmnRuntime.addListener(l);
                    }
                });
            }
            LOG.debug("Will deserialize payload: {}", (Object)contextPayload);
            DMNContextKS evalCtx = (DMNContextKS)this.marshallerHelper.unmarshal(containerId, contextPayload, marshallingType, DMNContextKS.class);
            DMNEvaluationUtils.DMNEvaluationResult evaluationResult = DMNEvaluationUtils.evaluate((DMNRuntime)dmnRuntime, (String)evalCtx.getNamespace(), (String)evalCtx.getModelName(), (Map)evalCtx.getDmnContext(), (List)evalCtx.getDecisionNames(), (List)evalCtx.getDecisionIds(), (String)evalCtx.getDecisionServiceName());
            DMNResultKS res = new DMNResultKS(evaluationResult.model.getNamespace(), evaluationResult.model.getName(), evalCtx.getDecisionNames(), evaluationResult.result);
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "OK from container '" + containerId + "'", (Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Error from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    public KieServerRegistry getKieServerRegistry() {
        return this.context;
    }
}

