/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.dmn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.core.ast.InputDataNodeImpl;
import org.kie.dmn.core.ast.ItemDefNodeImpl;
import org.kie.dmn.core.internal.utils.DMNEvaluationUtils;
import org.kie.dmn.core.internal.utils.DynamicDMNContextBuilder;
import org.kie.dmn.feel.lang.types.impl.ComparablePeriod;
import org.kie.dmn.model.api.BusinessKnowledgeModel;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.dmn.DMNContextKS;
import org.kie.server.api.model.dmn.DMNDecisionInfo;
import org.kie.server.api.model.dmn.DMNDecisionServiceInfo;
import org.kie.server.api.model.dmn.DMNInputDataInfo;
import org.kie.server.api.model.dmn.DMNItemDefinitionInfo;
import org.kie.server.api.model.dmn.DMNModelInfo;
import org.kie.server.api.model.dmn.DMNModelInfoList;
import org.kie.server.api.model.dmn.DMNQNameInfo;
import org.kie.server.api.model.dmn.DMNResultKS;
import org.kie.server.api.model.dmn.DMNUnaryTestsInfo;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.dmn.modelspecific.DMNFEELComparablePeriodSerializer;
import org.kie.server.services.dmn.modelspecific.KogitoDMNResult;
import org.kie.server.services.dmn.modelspecific.OASGenerator;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.kie.server.services.prometheus.PrometheusKieServerExtension;
import org.kie.server.services.prometheus.PrometheusMetricsDMNListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelEvaluatorServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(ModelEvaluatorServiceBase.class);
    private KieServerRegistry context;
    private MarshallerHelper marshallerHelper;
    private static final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new SimpleModule().addSerializer(ComparablePeriod.class, (JsonSerializer)new DMNFEELComparablePeriodSerializer())).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);

    public ModelEvaluatorServiceBase(KieServerRegistry context) {
        this.context = context;
        this.marshallerHelper = new MarshallerHelper(context);
    }

    public ServiceResponse<DMNModelInfoList> getModels(String containerId) {
        try {
            KieContainerInstanceImpl kContainer = this.context.getContainer(containerId, ContainerLocatorProvider.get().getLocator());
            DMNRuntime kieRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kContainer.getKieContainer().getKieBase()).get(DMNRuntime.class);
            List models = kieRuntime.getModels();
            List result = models.stream().map(ModelEvaluatorServiceBase::modelToInfo).collect(Collectors.toList());
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "OK models successfully retrieved from container '" + containerId + "'", (Object)new DMNModelInfoList(result));
        }
        catch (Exception e) {
            LOG.error("Error retrieving models from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error retrieving models from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    public static DMNModelInfo modelToInfo(DMNModel model) {
        DMNModelInfo res = new DMNModelInfo();
        res.setNamespace(model.getNamespace());
        res.setName(model.getName());
        res.setId(model.getDefinitions().getId());
        res.setDecisions((Collection)model.getDecisions().stream().map(ModelEvaluatorServiceBase::decisionToInfo).collect(Collectors.toSet()));
        res.setDecisionServices((Collection)model.getDecisionServices().stream().map(ModelEvaluatorServiceBase::decisionServiceToInfo).collect(Collectors.toSet()));
        res.setInputs((Collection)model.getInputs().stream().map(ModelEvaluatorServiceBase::inputDataToInfo).collect(Collectors.toSet()));
        res.setItemDefinitions((Collection)model.getItemDefinitions().stream().map(id -> ModelEvaluatorServiceBase.itemDefinitionToInfo(((ItemDefNodeImpl)id).getItemDef())).collect(Collectors.toSet()));
        return res;
    }

    public static DMNDecisionServiceInfo decisionServiceToInfo(DecisionServiceNode dsNode) {
        DMNDecisionServiceInfo res = new DMNDecisionServiceInfo();
        res.setName(dsNode.getName());
        res.setId(dsNode.getId());
        return res;
    }

    public static DMNDecisionInfo decisionToInfo(DecisionNode decisionNode) {
        DMNDecisionInfo res = new DMNDecisionInfo();
        res.setName(decisionNode.getName());
        res.setId(decisionNode.getId());
        return res;
    }

    public static DMNInputDataInfo inputDataToInfo(InputDataNode inputDataNode) {
        DMNInputDataInfo res = new DMNInputDataInfo();
        res.setName(inputDataNode.getName());
        res.setId(inputDataNode.getId());
        InputData id = ((InputDataNodeImpl)inputDataNode).getInputData();
        QName typeRef = id.getVariable().getTypeRef();
        if (typeRef != null) {
            if ("".equals(typeRef.getNamespaceURI())) {
                String actualNS = id.getNamespaceURI(typeRef.getPrefix());
                typeRef = new QName(actualNS, typeRef.getLocalPart(), typeRef.getPrefix());
            }
            res.setTypeRef(DMNQNameInfo.of((QName)typeRef));
        }
        return res;
    }

    public static DMNItemDefinitionInfo itemDefinitionToInfo(ItemDefinition itemDef) {
        DMNItemDefinitionInfo res = new DMNItemDefinitionInfo();
        res.setId(itemDef.getId());
        res.setName(itemDef.getName());
        if (itemDef.getTypeRef() != null) {
            res.setTypeRef(DMNQNameInfo.of((QName)itemDef.getTypeRef()));
        }
        if (itemDef.getAllowedValues() != null) {
            DMNUnaryTestsInfo av = new DMNUnaryTestsInfo();
            av.setText(itemDef.getAllowedValues().getText());
            av.setExpressionLanguage(itemDef.getAllowedValues().getExpressionLanguage());
            res.setAllowedValues(av);
        }
        if (itemDef.getItemComponent() != null && !itemDef.getItemComponent().isEmpty()) {
            List components = itemDef.getItemComponent().stream().map(ModelEvaluatorServiceBase::itemDefinitionToInfo).collect(Collectors.toList());
            res.setItemComponent(components);
        }
        res.setTypeLanguage(itemDef.getTypeLanguage());
        res.setIsCollection(Boolean.valueOf(itemDef.isIsCollection()));
        return res;
    }

    public ServiceResponse<DMNResultKS> evaluateDecisions(String containerId, String contextPayload, String marshallingType) {
        try {
            KieContainerInstanceImpl kContainer = this.context.getContainer(containerId, ContainerLocatorProvider.get().getLocator());
            DMNRuntime dmnRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kContainer.getKieContainer().getKieBase()).get(DMNRuntime.class);
            this.wirePrometheus(kContainer, dmnRuntime);
            LOG.debug("Will deserialize payload: {}", (Object)contextPayload);
            DMNContextKS evalCtx = (DMNContextKS)this.marshallerHelper.unmarshal(containerId, contextPayload, marshallingType, DMNContextKS.class);
            DMNEvaluationUtils.DMNEvaluationResult evaluationResult = DMNEvaluationUtils.evaluate((DMNRuntime)dmnRuntime, (String)evalCtx.getNamespace(), (String)evalCtx.getModelName(), (Map)evalCtx.getDmnContext(), (List)evalCtx.getDecisionNames(), (List)evalCtx.getDecisionIds(), (String)evalCtx.getDecisionServiceName());
            DMNResultKS res = new DMNResultKS(evaluationResult.model.getNamespace(), evaluationResult.model.getName(), evalCtx.getDecisionNames(), evaluationResult.result);
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "OK from container '" + containerId + "'", (Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Error from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    public Response evaluateModel(String containerId, String modelId, String contextPayload, boolean asDmnResult, String decisionServiceId) {
        try {
            KieContainerInstanceImpl kContainer = this.context.getContainer(containerId, ContainerLocatorProvider.get().getLocator());
            DMNRuntime dmnRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kContainer.getKieContainer().getKieBase()).get(DMNRuntime.class);
            List modelsWithID = dmnRuntime.getModels().stream().filter(m -> m.getName().equals(modelId)).collect(Collectors.toList());
            if (modelsWithID.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No model identifies with modelId: " + modelId)).build();
            }
            if (modelsWithID.size() > 1) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("More than one existing DMN model having modelId: " + modelId)).build();
            }
            DMNModel dmnModel = (DMNModel)modelsWithID.get(0);
            DecisionServiceNode determinedDS = null;
            if (decisionServiceId != null) {
                Optional<DecisionServiceNode> dsOpt = dmnModel.getDecisionServices().stream().filter(ds -> ds.getName().equals(decisionServiceId)).findFirst();
                if (!dsOpt.isPresent()) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No decisionService found: " + decisionServiceId)).build();
                }
                determinedDS = dsOpt.get();
            }
            Map jsonContextMap = (Map)objectMapper.readValue(contextPayload, (TypeReference)new TypeReference<Map<String, Object>>(){});
            DMNContext dmnContext = new DynamicDMNContextBuilder(dmnRuntime.newContext(), dmnModel).populateContextWith(jsonContextMap);
            this.wirePrometheus(kContainer, dmnRuntime);
            DMNResult determinedResult = null;
            determinedResult = determinedDS != null ? dmnRuntime.evaluateDecisionService(dmnModel, dmnContext, determinedDS.getName()) : dmnRuntime.evaluateAll(dmnModel, dmnContext);
            KogitoDMNResult result = new KogitoDMNResult(dmnModel.getNamespace(), dmnModel.getName(), determinedResult);
            if (asDmnResult) {
                return Response.ok().entity((Object)objectMapper.writeValueAsString((Object)result)).build();
            }
            String responseJSON = null;
            responseJSON = determinedDS != null && determinedDS.getDecisionService().getOutputDecision().size() == 1 ? objectMapper.writeValueAsString(result.getDecisionResults().get(0).getResult()) : objectMapper.writeValueAsString(result.getDmnContext());
            Response.ResponseBuilder response = Response.ok();
            if (result.hasErrors()) {
                String infoWarns = result.getMessages().stream().map(m -> m.getLevel() + " " + m.getMessage()).collect(Collectors.joining(", "));
                response.header("X-Kogito-decision-messages", (Object)infoWarns);
            }
            response.entity((Object)responseJSON);
            return response.build();
        }
        catch (Exception e) {
            LOG.error("Error from container '" + containerId + "'", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private void wirePrometheus(KieContainerInstanceImpl kContainer, DMNRuntime dmnRuntime) {
        PrometheusKieServerExtension extension = (PrometheusKieServerExtension)this.context.getServerExtension("Prometheus");
        if (extension != null) {
            PrometheusMetricsDMNListener listener = new PrometheusMetricsDMNListener(PrometheusKieServerExtension.getMetrics(), (KieContainerInstance)kContainer);
            dmnRuntime.addListener((DMNRuntimeEventListener)listener);
            List listeners = extension.getDMNRuntimeListeners((KieContainerInstance)kContainer);
            listeners.forEach(l -> {
                if (!dmnRuntime.getListeners().contains(l)) {
                    dmnRuntime.addListener(l);
                }
            });
        }
    }

    public KieServerRegistry getKieServerRegistry() {
        return this.context;
    }

    public Response getModel(String containerId, String modelId) {
        try {
            KieContainerInstanceImpl kContainer = this.context.getContainer(containerId, ContainerLocatorProvider.get().getLocator());
            DMNRuntime dmnRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kContainer.getKieContainer().getKieBase()).get(DMNRuntime.class);
            List modelsWithID = dmnRuntime.getModels().stream().filter(m -> m.getName().equals(modelId)).collect(Collectors.toList());
            if (modelsWithID.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No model identifies with modelId: " + modelId)).build();
            }
            if (modelsWithID.size() > 1) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("More than one existing DMN model having modelId: " + modelId)).build();
            }
            DMNModel dmnModel = (DMNModel)modelsWithID.get(0);
            Definitions definitions = dmnModel.getDefinitions();
            for (DRGElement drg : definitions.getDrgElement()) {
                if (drg instanceof Decision) {
                    Decision decision = (Decision)drg;
                    decision.setExpression(null);
                    continue;
                }
                if (!(drg instanceof BusinessKnowledgeModel)) continue;
                BusinessKnowledgeModel bkm = (BusinessKnowledgeModel)drg;
                bkm.setEncapsulatedLogic(null);
            }
            String xml = DMNMarshallerFactory.newDefaultMarshaller().marshal((Object)definitions);
            return Response.ok().entity((Object)xml).build();
        }
        catch (Exception e) {
            LOG.error("Error from container '" + containerId + "'", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    public Response getOAS(String containerId, boolean asJSON) {
        try {
            KieContainerInstanceImpl kContainer = this.context.getContainer(containerId, ContainerLocatorProvider.get().getLocator());
            ReleaseId resolvedReleaseId = kContainer.getKieContainer().getResolvedReleaseId();
            DMNRuntime dmnRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kContainer.getKieContainer().getKieBase()).get(DMNRuntime.class);
            List models = dmnRuntime.getModels();
            String content = new OASGenerator(containerId, resolvedReleaseId).generateOAS(models, asJSON);
            return Response.ok().entity((Object)content).build();
        }
        catch (Exception e) {
            LOG.error("Error from container '" + containerId + "'", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

