/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.drools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.api.builder.ReleaseId;
import org.kie.api.remote.Remotable;
import org.kie.scanner.KieModuleMetaData;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieContainerCommandServiceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsKieServerExtension
implements KieServerExtension {
    private static final Logger logger = LoggerFactory.getLogger(DroolsKieServerExtension.class);
    public static final String EXTENSION_NAME = "Drools";
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.drools.server.ext.disabled", "false"));
    private static final Boolean filterRemoteable = Boolean.parseBoolean(System.getProperty("org.drools.server.filter.classes", "false"));
    private KieContainerCommandService batchCommandService;
    private KieServerRegistry registry;

    public boolean isActive() {
        return disabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.batchCommandService = new KieContainerCommandServiceImpl(kieServer, registry);
        this.registry = registry;
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        HashSet extraClasses = new HashSet();
        Collection kbases = kieContainerInstance.getKieContainer().getKieBaseNames();
        for (String kbase : kbases) {
            kieContainerInstance.getKieContainer().getKieBase(kbase);
        }
        KieModuleMetaData metaData = KieModuleMetaData.Factory.newKieModuleMetaData((ReleaseId)kieContainerInstance.getKieContainer().getReleaseId());
        Collection packages = metaData.getPackages();
        for (String p : packages) {
            Collection classes = metaData.getClasses(p);
            for (String c : classes) {
                String type = p + "." + c;
                try {
                    logger.debug("Adding {} type into extra jaxb classes set", (Object)type);
                    Class<?> clazz = Class.forName(type, true, kieContainerInstance.getKieContainer().getClassLoader());
                    if (filterRemoteable.booleanValue()) {
                        if (!clazz.isAnnotationPresent(XmlRootElement.class) && !clazz.isAnnotationPresent(Remotable.class)) continue;
                        extraClasses.add(clazz);
                        logger.debug("Added {} type into extra jaxb classes set", (Object)type);
                        continue;
                    }
                    extraClasses.add(clazz);
                    logger.debug("Added {} type into extra jaxb classes set", (Object)type);
                }
                catch (ClassNotFoundException e) {
                    logger.warn("Unable to create instance of type {} due to {}", (Object)type, (Object)e.getMessage());
                    logger.debug("Complete stack trace for exception while creating type {}", (Object)type, (Object)e);
                }
                catch (Throwable e) {
                    logger.warn("Unexpected error while create instance of type {} due to {}", (Object)type, (Object)e.getMessage());
                    logger.debug("Complete stack trace for unknown error while creating type {}", (Object)type, (Object)e);
                }
            }
        }
        kieContainerInstance.addJaxbClasses(extraClasses);
        kieContainerInstance.addService((Object)this.batchCommandService);
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        kieContainerInstance.removeService(this.batchCommandService.getClass());
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.batchCommandService, this.registry};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (serviceType.isAssignableFrom(this.batchCommandService.getClass())) {
            return (T)this.batchCommandService;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "BRM";
    }

    public String toString() {
        return "Drools KIE Server extension";
    }
}

