/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.process.svg.SVGImageProcessor;
import org.jbpm.process.svg.processor.SVGProcessor;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.api.runtime.query.QueryContext;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.jbpm.ui.img.ImageReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(ImageServiceBase.class);
    private static final int MAX_NODES = Integer.parseInt(System.getProperty("org.kie.server.service.image.max_nodes", "1000"));
    private RuntimeDataService dataService;
    private Map<String, ImageReference> imageReferenceMap;
    private String kieServerLocation;
    private String processInstanceImageLink = "containers/{0}/images/processes/instances/{1}";
    private KieServerRegistry registry;

    public ImageServiceBase() {
        this.kieServerLocation = "";
    }

    public ImageServiceBase(RuntimeDataService dataService, Map<String, ImageReference> imageReferenceMap, KieServerRegistry registry) {
        this.dataService = dataService;
        this.imageReferenceMap = imageReferenceMap;
        this.registry = registry;
        this.kieServerLocation = this.registry.getConfig().getConfigItemValue("org.kie.server.location", System.getProperty("org.kie.server.location", "unknown"));
        if (!this.kieServerLocation.endsWith("/")) {
            this.kieServerLocation = this.kieServerLocation + "/";
        }
    }

    private byte[] getProcessImageAsBytes(String containerId, String processId) {
        byte[] imageSVG;
        ProcessDefinition procDef = this.dataService.getProcessesByDeploymentIdProcessId(containerId, processId);
        if (procDef == null) {
            throw new IllegalArgumentException("No process found for " + processId + " within container " + containerId);
        }
        String location = "";
        if (procDef.getPackageName() != null && !procDef.getPackageName().trim().isEmpty()) {
            location = procDef.getPackageName().replaceAll("\\.", "/") + "/";
        }
        if ((imageSVG = this.imageReferenceMap.get(containerId).getImageContent(location, processId)) == null) {
            logger.warn("Could not find SVG image file for process '" + processId + "' within container " + containerId);
            return null;
        }
        return imageSVG;
    }

    public String getProcessImage(String containerId, String processId) {
        containerId = this.registry.getContainerId(containerId, ContainerLocatorProvider.get().getLocator());
        String imageSVGString = null;
        byte[] imageSVG = this.getProcessImageAsBytes(containerId, processId);
        if (imageSVG != null) {
            ByteArrayInputStream svgStream = new ByteArrayInputStream(imageSVG);
            SVGProcessor processor = new SVGImageProcessor((InputStream)svgStream).getProcessor();
            imageSVGString = processor.getSVG();
        }
        return imageSVGString;
    }

    public String getActiveProcessImage(String containerId, long procInstId) {
        return this.getActiveProcessImage(containerId, procInstId, "#C0C0C0", "#030303", "#1e90ff", false, "#FF0000");
    }

    public String getActiveProcessImage(String containerId, long procInstId, String completedNodeColor, String completedNodeBorderColor, String activeNodeBorderColor, Boolean showBadges, String activeAsyncNodeBorderColor) {
        ProcessInstanceDesc instance = this.dataService.getProcessInstanceById(procInstId);
        if (instance == null) {
            throw new ProcessInstanceNotFoundException("No instance found for process instance id " + procInstId);
        }
        String imageSVGString = null;
        byte[] imageSVG = this.getProcessImageAsBytes(instance.getDeploymentId(), instance.getProcessId());
        if (imageSVG != null) {
            HashMap<String, String> subProcessLinks = new HashMap<String, String>();
            QueryContext qc = MAX_NODES > 0 ? new QueryContext(Integer.valueOf(0), Integer.valueOf(MAX_NODES)) : null;
            Collection activeLogs = this.dataService.getProcessInstanceHistoryActive(procInstId, qc);
            Collection finishedLogs = this.dataService.getProcessInstanceHistoryFinished(procInstId, qc);
            Collection fullLogs = this.dataService.getProcessInstanceFullHistory(procInstId, qc);
            List activeAsyncNodes = fullLogs.stream().filter(nodeInstanceDesc -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)nodeInstanceDesc).getType() == 6 && fullLogs.stream().noneMatch(nodeInst -> nodeInstanceDesc.getNodeId().equals(nodeInst.getNodeId()) && ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)nodeInst).getType() == 1)).map(NodeInstanceDesc::getNodeId).collect(Collectors.toList());
            HashMap<Long, String> active = new HashMap<Long, String>();
            ArrayList<String> completed = new ArrayList<String>();
            for (NodeInstanceDesc activeNode2 : activeLogs) {
                active.put(activeNode2.getId(), activeNode2.getNodeId());
            }
            for (NodeInstanceDesc completeNode : finishedLogs) {
                completed.add(completeNode.getNodeId());
                active.remove(completeNode.getId());
                this.populateSubProcessLink(containerId, completeNode, subProcessLinks);
            }
            activeLogs.forEach(activeNode -> this.populateSubProcessLink(containerId, (NodeInstanceDesc)activeNode, (Map<String, String>)subProcessLinks));
            fullLogs.stream().filter(node -> ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)node).getType() != RuntimeDataService.EntryType.START.getValue() && ((org.jbpm.kie.services.impl.model.NodeInstanceDesc)node).getType() != RuntimeDataService.EntryType.END.getValue()).forEach(node -> this.populateSubProcessLink(containerId, (NodeInstanceDesc)node, (Map<String, String>)subProcessLinks));
            Map<String, Long> badges = null;
            if (showBadges.booleanValue()) {
                ArrayList allNodes = new ArrayList();
                allNodes.addAll(finishedLogs);
                allNodes.addAll(activeLogs);
                badges = allNodes.stream().collect(Collectors.groupingBy(NodeInstanceDesc::getNodeId, Collectors.counting()));
            }
            ByteArrayInputStream svgStream = new ByteArrayInputStream(imageSVG);
            imageSVGString = SVGImageProcessor.transform((InputStream)svgStream, completed, new ArrayList(active.values()), activeAsyncNodes, subProcessLinks, (String)completedNodeColor, (String)completedNodeBorderColor, (String)activeNodeBorderColor, (String)activeAsyncNodeBorderColor, badges);
            return imageSVGString;
        }
        throw new IllegalArgumentException("No process found for " + instance.getProcessId() + " within container " + containerId);
    }

    protected void populateSubProcessLink(String containerId, NodeInstanceDesc node, Map<String, String> subProcessLinks) {
        if (node.getReferenceId() != null && node.getNodeType().endsWith("SubProcessNode")) {
            String link = this.kieServerLocation + MessageFormat.format(this.processInstanceImageLink, containerId, node.getReferenceId().toString());
            subProcessLinks.put(node.getNodeId(), link);
        }
    }
}

