/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.ui.form.render;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Map;
import org.kie.server.services.jbpm.ui.form.render.model.FormInstance;
import org.kie.server.services.jbpm.ui.form.render.model.LayoutRow;

public class FormReader {
    private final ObjectMapper mapper = new ObjectMapper().findAndRegisterModules().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));

    public FormInstance readFromString(String formStructure) {
        if (formStructure == null) {
            return null;
        }
        try {
            FormInstance formInstance = (FormInstance)this.mapper.readValue(formStructure, FormInstance.class);
            return this.flatColumnData(formInstance);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FormInstance readFromStream(InputStream formStructure) {
        try {
            FormInstance formInstance = (FormInstance)this.mapper.readValue(formStructure, FormInstance.class);
            return this.flatColumnData(formInstance);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> extractValues(Object data) {
        if (data == null) {
            return Collections.emptyMap();
        }
        return (Map)this.mapper.convertValue(data, Map.class);
    }

    public String toJson(Object data) {
        if (data == null) {
            return "{}";
        }
        try {
            return this.mapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected FormInstance flatColumnData(FormInstance formInstance) {
        if (formInstance.getLayout() != null) {
            for (LayoutRow row : formInstance.getLayout().getRows()) {
                row.getColumns().forEach(c -> c.flatItems());
            }
        }
        return formInstance;
    }
}

