/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.jbpm.services.api.DeploymentService;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.ModelWrapper;
import org.kie.server.api.model.KieServerCommand;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.Wrapped;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.DefinitionServiceBase;
import org.kie.server.services.jbpm.DocumentServiceBase;
import org.kie.server.services.jbpm.ExecutorServiceBase;
import org.kie.server.services.jbpm.ProcessServiceBase;
import org.kie.server.services.jbpm.QueryDataServiceBase;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.kie.server.services.jbpm.UserTaskServiceBase;
import org.kie.server.services.jbpm.admin.ProcessAdminServiceBase;
import org.kie.server.services.jbpm.admin.UserTaskAdminServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMKieContainerCommandServiceImpl
implements KieContainerCommandService {
    private static final Logger logger = LoggerFactory.getLogger(JBPMKieContainerCommandServiceImpl.class);
    private KieServerRegistry context;
    private DeploymentService deploymentService;
    private DefinitionServiceBase definitionServiceBase;
    private ProcessServiceBase processServiceBase;
    private UserTaskServiceBase userTaskServiceBase;
    private RuntimeDataServiceBase runtimeDataServiceBase;
    private ExecutorServiceBase executorServiceBase;
    private QueryDataServiceBase queryDataServiceBase;
    private DocumentServiceBase documentServiceBase;
    private ProcessAdminServiceBase processAdminServiceBase;
    private UserTaskAdminServiceBase userTaskAdminServiceBase;

    public JBPMKieContainerCommandServiceImpl(KieServerRegistry context, DeploymentService deploymentService, DefinitionServiceBase definitionServiceBase, ProcessServiceBase processServiceBase, UserTaskServiceBase userTaskServiceBase, RuntimeDataServiceBase runtimeDataServiceBase, ExecutorServiceBase executorServiceBase, QueryDataServiceBase queryDataServiceBase, DocumentServiceBase documentServiceBase, ProcessAdminServiceBase processAdminServiceBase, UserTaskAdminServiceBase userTaskAdminServiceBase) {
        this.context = context;
        this.deploymentService = deploymentService;
        this.definitionServiceBase = definitionServiceBase;
        this.processServiceBase = processServiceBase;
        this.userTaskServiceBase = userTaskServiceBase;
        this.runtimeDataServiceBase = runtimeDataServiceBase;
        this.executorServiceBase = executorServiceBase;
        this.queryDataServiceBase = queryDataServiceBase;
        this.documentServiceBase = documentServiceBase;
        this.processAdminServiceBase = processAdminServiceBase;
        this.userTaskAdminServiceBase = userTaskAdminServiceBase;
    }

    public ServiceResponse<String> callContainer(String containerId, String payload, MarshallingFormat marshallingFormat, String classType) {
        return null;
    }

    public ServiceResponsesList executeScript(CommandScript commands, MarshallingFormat marshallingFormat, String classType) {
        ArrayList<ServiceResponse> responses = new ArrayList<ServiceResponse>();
        for (KieServerCommand command : commands.getCommands()) {
            if (!(command instanceof DescriptorCommand)) {
                logger.warn("Unsupported command '{}' given, will not process it", (Object)command.getClass().getName());
                continue;
            }
            boolean wrapResults = false;
            try {
                Object result = null;
                Object handler = null;
                DescriptorCommand descriptorCommand = (DescriptorCommand)command;
                if ("DefinitionService".equals(descriptorCommand.getService())) {
                    handler = this.definitionServiceBase;
                } else if ("ProcessService".equals(descriptorCommand.getService())) {
                    handler = this.processServiceBase;
                } else if ("UserTaskService".equals(descriptorCommand.getService())) {
                    handler = this.userTaskServiceBase;
                } else if ("QueryService".equals(descriptorCommand.getService())) {
                    handler = this.runtimeDataServiceBase;
                } else if ("JobService".equals(descriptorCommand.getService())) {
                    handler = this.executorServiceBase;
                } else if ("QueryDataService".equals(descriptorCommand.getService())) {
                    handler = this.queryDataServiceBase;
                    if (marshallingFormat.equals((Object)MarshallingFormat.JAXB)) {
                        wrapResults = true;
                    }
                } else if ("DocumentService".equals(descriptorCommand.getService())) {
                    handler = this.documentServiceBase;
                } else if ("ProcessAdminService".equals(descriptorCommand.getService())) {
                    handler = this.processAdminServiceBase;
                } else if ("UserTaskAdminService".equals(descriptorCommand.getService())) {
                    handler = this.userTaskAdminServiceBase;
                } else {
                    throw new IllegalStateException("Unable to find handler for " + descriptorCommand.getService() + " service");
                }
                ArrayList arguments = new ArrayList();
                for (Object arg : descriptorCommand.getArguments()) {
                    logger.debug("Before :: Argument with type {} and value {}", arg.getClass(), arg);
                    if (arg instanceof Wrapped) {
                        arg = ((Wrapped)arg).unwrap();
                    }
                    logger.debug("After :: Argument with type {} and value {}", arg.getClass(), arg);
                    arguments.add(arg);
                }
                if (descriptorCommand.getPayload() != null && !descriptorCommand.getPayload().isEmpty()) {
                    arguments.add(descriptorCommand.getPayload());
                }
                if (descriptorCommand.getMarshallerFormat() != null && !descriptorCommand.getMarshallerFormat().isEmpty()) {
                    arguments.add(descriptorCommand.getMarshallerFormat());
                }
                logger.debug("About to execute {} operation on {} with args {}", new Object[]{descriptorCommand.getMethod(), handler, arguments});
                result = MethodUtils.invokeMethod((Object)handler, (String)descriptorCommand.getMethod(), (Object[])arguments.toArray());
                logger.debug("Handler {} returned response {}", handler, result);
                if (wrapResults) {
                    result = ModelWrapper.wrap((Object)result);
                    logger.debug("Wrapped response is {}", result);
                }
                responses.add(new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "", result));
            }
            catch (InvocationTargetException e) {
                logger.error("Error while processing {} command", (Object)command, (Object)e);
                responses.add(new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, e.getTargetException().getMessage()));
            }
            catch (Throwable e) {
                logger.error("Error while processing {} command", (Object)command, (Object)e);
                responses.add(new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, e.getMessage()));
            }
        }
        logger.debug("About to return responses '{}'", responses);
        return new ServiceResponsesList(responses);
    }
}

