/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.locator;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.server.services.api.ContainerLocator;
import org.kie.server.services.jbpm.locator.ByContextMappingInfoContainerLocator;
import org.kie.server.services.jbpm.locator.ByProcessInstanceIdContainerLocator;
import org.kie.server.services.jbpm.locator.ContainerLocatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessContainerLocatorProvider {
    private static final Logger logger = LoggerFactory.getLogger(ProcessContainerLocatorProvider.class);
    private static final ProcessContainerLocatorProvider INSTANCE = new ProcessContainerLocatorProvider();
    private final Map<String, ContainerLocatorFactory> locators = new HashMap<String, ContainerLocatorFactory>();

    private ProcessContainerLocatorProvider() {
        ServiceLoader<ContainerLocatorFactory> containerLocators = ServiceLoader.load(ContainerLocatorFactory.class);
        containerLocators.forEach(l -> {
            this.locators.put(l.getClass().getSimpleName(), (ContainerLocatorFactory)l);
            logger.info("Discovered '{}' container locator factory and registered under '{}'", l, (Object)l.getClass().getSimpleName());
        });
        this.locators.put(ByProcessInstanceIdContainerLocator.class.getSimpleName(), ByProcessInstanceIdContainerLocator.Factory.get());
        this.locators.put(ByContextMappingInfoContainerLocator.class.getSimpleName(), ByContextMappingInfoContainerLocator.Factory.get());
    }

    public ContainerLocator getLocator(Number processInstanceId) {
        String processInstanceLocatorName = System.getProperty("org.kie.server.process.instance.container.locator", ByProcessInstanceIdContainerLocator.class.getSimpleName());
        ContainerLocatorFactory containerLocatorFactory = this.locators.get(processInstanceLocatorName);
        if (containerLocatorFactory == null) {
            throw new IllegalStateException("No container locator factory found under name " + processInstanceLocatorName + " please review '" + "org.kie.server.process.instance.container.locator" + "' property value");
        }
        logger.info("Container locator factory was found '{}'", (Object)containerLocatorFactory.getClass().getSimpleName());
        return containerLocatorFactory.create(processInstanceId);
    }

    public static ProcessContainerLocatorProvider get() {
        return INSTANCE;
    }
}

