/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.services.jbpm.kafka.KafkaEventReader;
import org.kie.server.services.jbpm.kafka.KafkaJsonUtils;

class CloudEventReader
implements KafkaEventReader {
    private ClassLoader cl;
    private Map<MarshallingFormat, Marshaller> marshallers = new EnumMap<MarshallingFormat, Marshaller>(MarshallingFormat.class);

    public CloudEventReader(ClassLoader cl) {
        this.cl = cl;
    }

    @Override
    public <T> T readEvent(byte[] value, Class<T> valueType) throws IOException {
        JsonNode node = KafkaJsonUtils.mapper.readTree(value);
        MarshallingFormat contentType = MarshallingFormat.JSON;
        if (node.has("datacontenttype")) {
            contentType = MarshallingFormat.fromType((String)node.get("datacontenttype").asText());
        }
        if (node.has("data")) {
            Marshaller marshaller = this.marshallers.computeIfAbsent(contentType, c -> MarshallerFactory.getMarshaller((MarshallingFormat)c, (ClassLoader)this.cl));
            return (T)marshaller.unmarshall(node.get("data").toString(), valueType);
        }
        throw new IOException("Missing data field in cloud event " + new String(value));
    }
}

