/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.openshift.impl.storage.cloud;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.impl.KieServerLocator;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepositoryUtils;
import org.kie.server.services.openshift.impl.storage.cloud.KieServerStateCloudRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerStateOpenShiftRepository
extends KieServerStateCloudRepository {
    private static final Logger logger = LoggerFactory.getLogger(KieServerStateOpenShiftRepository.class);

    public synchronized void create(@NotNull KieServerState kieServerState) {
        String serverId = this.retrieveKieServerId(kieServerState);
        this.processKieServerStateByOpenShift(client -> {
            ConfigMap cm = (ConfigMap)((Resource)client.configMaps().withName(serverId)).get();
            if (cm != null) {
                logger.info("Create new ConfigMap action ignored. ConfigMap for KieServer [{}] exists.", (Object)serverId);
                return null;
            }
            this.createNewKieServerStateCM(kieServerState, serverId, (OpenShiftClient)client);
            return null;
        });
    }

    public List<String> retrieveAllKieServerIds() {
        return this.processKieServerStateByOpenShift(client -> ((ConfigMapList)((FilterWatchListDeletable)client.configMaps().withLabelIn("services.server.kie.org/kie-server-state", new String[]{"IMMUTABLE", "USED"})).list()).getItems().stream().map(cfg -> cfg.getMetadata().getName()).collect(Collectors.toList()));
    }

    public List<KieServerState> retrieveAllKieServerStates() {
        return this.processKieServerStateByOpenShift(client -> ((ConfigMapList)((FilterWatchListDeletable)client.configMaps().withLabelIn("services.server.kie.org/kie-server-state", new String[]{"IMMUTABLE", "USED"})).list()).getItems().stream().map(cfg -> (KieServerState)this.xs.fromXML((String)cfg.getData().get("kie-server-state"))).collect(Collectors.toList()));
    }

    public boolean exists(String id) {
        return this.processKieServerStateByOpenShift(client -> ((Resource)client.configMaps().withName(id)).get() != null);
    }

    public KieServerState delete(String id) {
        KieServerState state = this.load(id);
        boolean isUnsupported = this.processKieServerStateByOpenShift(client -> {
            if (((DeployableScalableResource)client.deploymentConfigs().withName(id)).get() != null) {
                return true;
            }
            ((Resource)client.configMaps().withName(id)).delete();
            return false;
        });
        if (isUnsupported) {
            logger.error("Can not delete attached KieServerState with id [{}].", (Object)id);
            throw new UnsupportedOperationException("Can not delete attached KieServerState with id [" + id + "]");
        }
        return state;
    }

    public synchronized void store(@NotNull String serverId, @NotNull KieServerState kieServerState) {
        if (!this.retrieveKieServerId(kieServerState).equals(serverId)) {
            throw new IllegalArgumentException("Invalid KieServerId: Id does not match with KieServerState.");
        }
        this.processKieServerStateByOpenShift(client -> {
            DeploymentConfig dc = (DeploymentConfig)((DeployableScalableResource)client.deploymentConfigs().withName(serverId)).get();
            ConfigMap cm = (ConfigMap)((Resource)client.configMaps().withName(serverId)).get();
            if (Boolean.parseBoolean(kieServerState.getConfiguration().getConfigItemValue("org.kie.server.state.immutable", Boolean.FALSE.toString()))) {
                if (Boolean.parseBoolean(System.getProperty("org.kie.server.state.immutable.init", Boolean.FALSE.toString()))) {
                    this.createNewKieServerStateCM(kieServerState, serverId, (OpenShiftClient)client);
                } else {
                    logger.debug("Overwrite immutable KieServer, id:{}, state is not allow.", (Object)serverId);
                }
            } else if (this.isServerStateUpdateAllowed(dc, cm, kieServerState)) {
                ObjectMeta md = cm.getMetadata();
                Map<String, String> ann = md.getAnnotations() == null ? new ConcurrentHashMap() : md.getAnnotations();
                md.setAnnotations(ann);
                ann.put("services.server.kie.org/kie-server-state.changeTimestamp", ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT));
                ann.put("services.server.kie.org/openshift-startup-strategy.rolloutRequired", "true");
                cm.setData(Collections.singletonMap("kie-server-state", this.xs.toXML((Object)kieServerState)));
                client.configMaps().createOrReplace((Object[])new ConfigMap[]{cm});
            }
            return null;
        });
    }

    public KieServerState load(@NotNull String serverId) {
        KieServerState kieServerState = this.processKieServerStateByOpenShift(client -> {
            ConfigMap cm = (ConfigMap)((Resource)client.configMaps().withName(serverId)).get();
            if (cm == null) {
                if (this.isKieServerRuntime()) {
                    KieServerState initkieServerState = new KieServerState();
                    KieServerConfig config = new KieServerConfig();
                    KieServerStateRepositoryUtils.populateWithSystemProperties((KieServerConfig)config);
                    initkieServerState.setConfiguration(config);
                    if (config.getConfigItemValue("org.kie.server.id") == null || !config.getConfigItemValue("org.kie.server.id").equals(serverId)) {
                        throw new IllegalStateException("KieServerId: [" + serverId + "], must NOT be null and be set by system property or environment varible.");
                    }
                    cm = this.createNewKieServerStateCM(initkieServerState, serverId, (OpenShiftClient)client);
                } else {
                    return null;
                }
            }
            return (KieServerState)this.xs.fromXML((String)cm.getData().get("kie-server-state"));
        });
        if (kieServerState == null) {
            if (this.isKieServerRuntime()) {
                throw new IllegalStateException("Invalid KieServerId: [" + serverId + "], load kie server state failed.");
            }
            return null;
        }
        if (!this.retrieveKieServerId(kieServerState).equals(serverId)) {
            throw new IllegalStateException("Inconsistent kie server state data, requested KieServerId: [" + serverId + "], whereas loaded KieServerId: [" + this.retrieveKieServerId(kieServerState) + "],from kie server state.");
        }
        return kieServerState;
    }

    @Override
    public boolean isKieServerReady() {
        return KieServerLocator.getInstance().isKieServerReady();
    }

    public boolean isKieContainerRemovalAllowed(ConfigMap cm, KieServerState newState) {
        KieServerState state = (KieServerState)this.xs.fromXML((String)cm.getData().get("kie-server-state"));
        for (KieContainerResource container : state.getContainers()) {
            if (!container.getStatus().equals((Object)KieContainerStatus.STOPPED) || !newState.getContainers().stream().noneMatch(c -> c.getContainerId().equals(container.getContainerId()))) continue;
            logger.warn("Removing STOPPED KieContainer by KieServer process is not allowed.");
            return false;
        }
        return true;
    }

    public boolean isKieContainerUpdateDuringRolloutAllowed(ConfigMap cm, KieServerState newState) {
        KieServerState state = (KieServerState)this.xs.fromXML((String)cm.getData().get("kie-server-state"));
        for (KieContainerResource container : state.getContainers()) {
            if (!container.getStatus().equals((Object)KieContainerStatus.STARTED) || !newState.getContainers().stream().anyMatch(c -> c.getContainerId().equals(container.getContainerId()) && c.getStatus().equals((Object)KieContainerStatus.STOPPED))) continue;
            logger.warn("Non KieServer process updated KieServerState during DC rollout for STOPPING containers.");
            return true;
        }
        logger.warn("Non KieServer process updates KieServerState during DC rollout is prohibited!");
        return false;
    }

    protected ConfigMap createNewKieServerStateCM(KieServerState kieServerState, String serverId, OpenShiftClient client) {
        String stateXML = this.xs.toXML((Object)kieServerState);
        Map<String, String> labels = null;
        labels = Boolean.parseBoolean(kieServerState.getConfiguration().getConfigItemValue("org.kie.server.state.immutable", "false")) ? Collections.singletonMap("services.server.kie.org/kie-server-state", "IMMUTABLE") : Collections.singletonMap("services.server.kie.org/kie-server-state", "USED");
        return (ConfigMap)client.configMaps().createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(serverId)).withLabels(labels)).endMetadata()).withData(Collections.singletonMap("kie-server-state", stateXML))).build()});
    }

    protected boolean isServerStateUpdateAllowed(DeploymentConfig dc, ConfigMap cm, KieServerState newState) {
        if (cm == null) {
            throw new IllegalStateException("KieServerState ConfigMap must exist before update.");
        }
        if (cm.getMetadata().getLabels() == null) {
            return false;
        }
        if (cm.getMetadata().getLabels().containsValue("USED")) {
            if (this.isKieServerRuntime()) {
                return this.isUpdateByKieServerProcessAllowed(dc, cm, newState);
            }
            return this.isUpdateByNonKieServerProcessAllowed(dc, cm, newState);
        }
        if (cm.getMetadata().getLabels().containsValue("IMMUTABLE")) {
            logger.warn("Add or remove kie container not allowed for immutable kie server: {}", (Object)cm.getMetadata().getName());
        }
        return false;
    }

    protected boolean isUpdateByNonKieServerProcessAllowed(DeploymentConfig dc, ConfigMap cm, KieServerState newState) {
        if (this.isDCStable(dc)) {
            logger.debug("Non KieServer process updated KieServerState.");
            return true;
        }
        return this.isKieContainerUpdateDuringRolloutAllowed(cm, newState);
    }

    protected boolean isUpdateByKieServerProcessAllowed(DeploymentConfig dc, ConfigMap cm, KieServerState newState) {
        if (!this.isKieContainerRemovalAllowed(cm, newState)) {
            return false;
        }
        if (!this.isKieServerReady()) {
            logger.debug("KieServerState updates during KieServer starting up is ignored!");
            return false;
        }
        if (!this.isDCStable(dc)) {
            logger.debug("KieServerState updates during DC rollout is ignored!");
            return false;
        }
        logger.debug("KieServer process updated KieServerState.");
        return true;
    }

    private boolean isKieServerRuntime() {
        return System.getProperty("org.kie.server.id") != null;
    }

    private <R> R processKieServerStateByOpenShift(Function<OpenShiftClient, R> func) {
        R result = null;
        try (OpenShiftClient client = this.createOpenShiftClient();){
            result = func.apply(client);
        }
        catch (UnsupportedOperationException uoe) {
            logger.error("Processing KieServerState failed - Unsupported", (Throwable)uoe);
            throw uoe;
        }
        catch (IllegalStateException ise) {
            logger.error("Processing KieServerState failed - Missing required configuration", (Throwable)ise);
            throw ise;
        }
        catch (Exception e) {
            logger.error("Processing KieServerState failed.", (Throwable)e);
        }
        return result;
    }
}

