/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.optaplanner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.optaplanner.OptaplannerCommandServiceImpl;
import org.kie.server.services.optaplanner.SolverServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptaplannerKieServerExtension
implements KieServerExtension {
    private static final Logger logger = LoggerFactory.getLogger(OptaplannerKieServerExtension.class);
    public static final String EXTENSION_NAME = "OptaPlanner";
    private static final Boolean droolsDisabled = Boolean.parseBoolean(System.getProperty("org.drools.server.ext.disabled", "false"));
    private static final Boolean disabled = Boolean.parseBoolean(System.getProperty("org.optaplanner.server.ext.disabled", "false"));
    private KieServerRegistry registry;
    private SolverServiceBase solverServiceBase;
    private ExecutorService threadPool = null;
    private List<Object> services = new ArrayList<Object>();
    private OptaplannerCommandServiceImpl optaplannerCommandService;

    public boolean isActive() {
        return disabled == false && droolsDisabled == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        KieServerExtension droolsExtension = registry.getServerExtension("Drools");
        if (droolsExtension == null) {
            logger.warn("No Drools extension available, quiting...");
            return;
        }
        this.registry = registry;
        int poolSize = Runtime.getRuntime().availableProcessors();
        if (poolSize >= 4) {
            --poolSize;
        }
        this.threadPool = new ThreadPoolExecutor(2, poolSize, 120L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(poolSize));
        this.solverServiceBase = new SolverServiceBase(registry, this.threadPool);
        this.optaplannerCommandService = new OptaplannerCommandServiceImpl(registry, this.solverServiceBase);
        this.services.add(this.solverServiceBase);
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        this.solverServiceBase.disposeSolversForContainer(id, kieContainerInstance);
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.solverServiceBase, this.registry};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (serviceType.isAssignableFrom(this.optaplannerCommandService.getClass())) {
            return (T)this.optaplannerCommandService;
        }
        if (serviceType.isAssignableFrom(this.solverServiceBase.getClass())) {
            return (T)this.solverServiceBase;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "BRP";
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 25;
    }

    public String toString() {
        return "OptaPlanner KIE Server extension";
    }
}

