/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.optaplanner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.api.model.instance.SolverInstanceList;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.optaplanner.SolverInstanceContext;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(SolverServiceBase.class);
    private final ExecutorService executor;
    private KieServerRegistry context;
    private Map<String, SolverInstanceContext> solvers = new ConcurrentHashMap<String, SolverInstanceContext>();

    public SolverServiceBase(KieServerRegistry context, ExecutorService executorService) {
        this.context = context;
        this.executor = executorService;
    }

    public ServiceResponse<SolverInstanceList> getSolvers(String containerId) {
        try {
            List<SolverInstance> sl = this.getSolversForContainer(containerId);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Solvers list successfully retrieved from container '" + containerId + "'", (Object)new SolverInstanceList(sl));
        }
        catch (Exception e) {
            logger.error("Error retrieving solvers list from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving solvers list from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<SolverInstance> createSolver(String containerId, String solverId, SolverInstance instance) {
        if (instance == null || instance.getSolverConfigFile() == null) {
            logger.error("Error creating solver. Configuration file name is null: " + instance);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Failed to create solver for container " + containerId + ". Solver configuration file is null: " + instance);
        }
        instance.setContainerId(containerId);
        instance.setSolverId(solverId);
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(containerId);
            if (ci == null) {
                logger.error("Error creating solver. Container does not exist: " + containerId);
                return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Failed to create solver. Container does not exist: " + containerId);
            }
            KieContainerInstanceImpl kieContainerInstanceImpl = ci;
            synchronized (kieContainerInstanceImpl) {
                if (this.solvers.containsKey(instance.getSolverInstanceKey())) {
                    logger.error("Error creating solver. Solver '" + solverId + "' already exists for container '" + containerId + "'.");
                    return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Failed to create solver. Solver '" + solverId + "' already exists for container '" + containerId + "'.");
                }
                SolverInstanceContext sic = new SolverInstanceContext(instance);
                if (instance.getStatus() == null) {
                    instance.setStatus(SolverInstance.SolverStatus.NOT_SOLVING);
                }
                try {
                    SolverFactory solverFactory = SolverFactory.createFromKieContainerXmlResource((KieContainer)ci.getKieContainer(), (String)instance.getSolverConfigFile());
                    Solver solver = solverFactory.buildSolver();
                    sic.setSolver(solver);
                    this.updateSolverInstance(sic);
                    this.solvers.put(instance.getSolverInstanceKey(), sic);
                    logger.info("Solver '" + solverId + "' successfully created in container '" + containerId + "'");
                    return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' successfully created in container '" + containerId + "'", (Object)instance);
                }
                catch (Exception e) {
                    logger.error("Error creating solver factory for solver " + instance, (Throwable)e);
                    return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error creating solver factory for solver: " + e.getMessage(), (Object)instance);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error creating solver '" + solverId + "' in container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error creating solver '" + solverId + "' in container '" + containerId + "': " + e.getMessage(), (Object)instance);
        }
    }

    public ServiceResponse<SolverInstance> getSolverState(String containerId, String solverId) {
        try {
            SolverInstanceContext sic = this.solvers.get(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
            if (sic != null) {
                this.updateSolverInstance(sic);
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' state successfully retrieved from container '" + containerId + "'", (Object)sic.getInstance());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' not found in container '" + containerId + "'", null);
        }
        catch (Exception e) {
            logger.error("Error retrieving solver '" + solverId + "' state from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving solver '" + solverId + "' state from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    public ServiceResponse<SolverInstance> getBestSolution(String containerId, String solverId) {
        try {
            SolverInstanceContext sic = this.solvers.get(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
            if (sic != null) {
                this.updateSolverInstance(sic);
                sic.getInstance().setBestSolution(sic.getSolver().getBestSolution());
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Best computed solution for '" + solverId + "' successfully retrieved from container '" + containerId + "'", (Object)sic.getInstance());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' not found in container '" + containerId + "'", null);
        }
        catch (Exception e) {
            logger.error("Error retrieving solver '" + solverId + "' state from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving solver '" + solverId + "' state from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<SolverInstance> updateSolverState(String containerId, String solverId, SolverInstance instance) {
        try {
            if (instance.getStatus() == null) {
                return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Solver status is a mandatory field on an update call.", (Object)instance);
            }
            if (instance.getStatus() != SolverInstance.SolverStatus.NOT_SOLVING && instance.getStatus() != SolverInstance.SolverStatus.SOLVING) {
                return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid solver status. Only SOLVING or NOT_SOLVING status can be set.", (Object)instance);
            }
            SolverInstanceContext sic = this.solvers.get(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
            if (sic != null) {
                SolverInstanceContext solverInstanceContext = sic;
                synchronized (solverInstanceContext) {
                    block3 : switch (sic.getInstance().getStatus()) {
                        case NOT_SOLVING: {
                            switch (instance.getStatus()) {
                                case SOLVING: {
                                    if (instance.getPlanningProblem() == null) {
                                        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Planning-problem is a mandatory field when starting the solver.", (Object)instance);
                                    }
                                    this.startSolver(sic, instance);
                                    break block3;
                                }
                                case TERMINATING_EARLY: 
                                case NOT_SOLVING: {
                                    return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' on container '" + containerId + "' already terminated.", null);
                                }
                            }
                            break;
                        }
                        case SOLVING: {
                            switch (instance.getStatus()) {
                                case TERMINATING_EARLY: 
                                case NOT_SOLVING: {
                                    this.terminateEarly(sic);
                                    break block3;
                                }
                                case SOLVING: {
                                    return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' on container '" + containerId + "' is already executing.", null);
                                }
                            }
                        }
                    }
                    this.updateSolverInstance(sic);
                    return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' from container '" + containerId + "' successfully updated.", (Object)sic.getInstance());
                }
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' not found in container '" + containerId + "'", null);
        }
        catch (Exception e) {
            logger.error("Error retrieving solver '" + solverId + "' state from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown error updating solver state.", null);
        }
    }

    public ServiceResponse<Void> disposeSolver(String containerId, String solverId) {
        try {
            SolverInstanceContext sic = this.internalDisposeSolver(containerId, solverId);
            if (sic != null) {
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' successfully disposed from container '" + containerId + "'", null);
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' from container '" + containerId + "' not found.", null);
        }
        catch (Exception e) {
            logger.error("Error disposing solver '" + solverId + "' from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error disposing solver '" + solverId + "' from container '" + containerId + "'. Message: " + e.getMessage(), null);
        }
    }

    public KieServerRegistry getKieServerRegistry() {
        return this.context;
    }

    public void disposeSolversForContainer(String containerId, KieContainerInstance kci) {
        List<SolverInstance> sfc = this.getSolversForContainer(containerId);
        for (SolverInstance si : sfc) {
            this.internalDisposeSolver(containerId, si.getSolverId());
        }
    }

    private List<SolverInstance> getSolversForContainer(String containerId) {
        ArrayList<SolverInstance> sl = new ArrayList<SolverInstance>(this.solvers.size());
        for (SolverInstanceContext sic : this.solvers.values()) {
            if (!containerId.equalsIgnoreCase(sic.getInstance().getContainerId())) continue;
            this.updateSolverInstance(sic);
            sl.add(sic.getInstance());
        }
        return sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolverInstanceContext internalDisposeSolver(String containerId, String solverId) {
        SolverInstanceContext sic = this.solvers.remove(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
        if (sic != null) {
            SolverInstanceContext solverInstanceContext = sic;
            synchronized (solverInstanceContext) {
                if (sic.getInstance().getStatus() == SolverInstance.SolverStatus.SOLVING) {
                    this.terminateEarly(sic);
                }
            }
        }
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSolverInstance(SolverInstanceContext sic) {
        SolverInstanceContext solverInstanceContext = sic;
        synchronized (solverInstanceContext) {
            Solution bestSolution = sic.getSolver().getBestSolution();
            sic.getInstance().setScore(bestSolution != null ? bestSolution.getScore() : null);
        }
    }

    private void updateSolverStatus(SolverInstanceContext sic) {
        Solver solver = sic.getSolver();
        if (!solver.isSolving()) {
            sic.getInstance().setStatus(SolverInstance.SolverStatus.NOT_SOLVING);
        } else if (solver.isTerminateEarly()) {
            sic.getInstance().setStatus(SolverInstance.SolverStatus.TERMINATING_EARLY);
        } else {
            sic.getInstance().setStatus(SolverInstance.SolverStatus.SOLVING);
        }
    }

    private void startSolver(final SolverInstanceContext sic, final SolverInstance instance) {
        sic.getInstance().setPlanningProblem(null);
        sic.getInstance().setBestSolution(null);
        sic.getInstance().setStatus(SolverInstance.SolverStatus.SOLVING);
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object status;
                    SolverInstanceContext solverInstanceContext = sic;
                    synchronized (solverInstanceContext) {
                        status = sic.getInstance().getStatus();
                    }
                    if (status == SolverInstance.SolverStatus.SOLVING) {
                        sic.getSolver().solve(instance.getPlanningProblem());
                    }
                }
                catch (Exception e) {
                    logger.error("Exception executing solver '" + sic.getInstance().getSolverId() + "' from container '" + sic.getInstance().getContainerId() + "'. Thread will terminate.", (Throwable)e);
                }
                finally {
                    SolverInstanceContext solverInstanceContext = sic;
                    synchronized (solverInstanceContext) {
                        sic.getInstance().setStatus(SolverInstance.SolverStatus.NOT_SOLVING);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateEarly(SolverInstanceContext sic) {
        SolverInstanceContext solverInstanceContext = sic;
        synchronized (solverInstanceContext) {
            if (sic.getInstance().getStatus() == SolverInstance.SolverStatus.SOLVING) {
                sic.getInstance().setStatus(SolverInstance.SolverStatus.TERMINATING_EARLY);
            }
        }
        sic.getSolver().terminateEarly();
    }
}

