/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.optaplanner;

import java.util.ArrayList;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.optaplanner.CreateSolverCommand;
import org.kie.server.api.commands.optaplanner.DisposeSolverCommand;
import org.kie.server.api.commands.optaplanner.GetBestSolutionCommand;
import org.kie.server.api.commands.optaplanner.GetSolverStateCommand;
import org.kie.server.api.commands.optaplanner.GetSolversCommand;
import org.kie.server.api.commands.optaplanner.UpdateSolverStateCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.optaplanner.SolverServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptaplannerCommandServiceImpl
implements KieContainerCommandService {
    private static final Logger logger = LoggerFactory.getLogger(OptaplannerCommandServiceImpl.class);
    private KieServerRegistry context;
    private SolverServiceBase solverService;

    public OptaplannerCommandServiceImpl(KieServerRegistry context, SolverServiceBase solverService) {
        this.context = context;
        this.solverService = solverService;
    }

    public ServiceResponse<String> callContainer(String containerId, String payload, MarshallingFormat marshallingFormat, String classType) {
        return null;
    }

    public ServiceResponsesList executeScript(CommandScript commands, MarshallingFormat marshallingFormat, String classType) {
        ArrayList<Object> responses = new ArrayList<Object>();
        for (KieServerCommand command : commands.getCommands()) {
            try {
                GetSolversCommand gss;
                Object response = null;
                logger.debug("About to execute command: {}", (Object)command);
                if (command instanceof CreateSolverCommand) {
                    CreateSolverCommand csc = (CreateSolverCommand)command;
                    SolverInstance instance = new SolverInstance();
                    instance.setContainerId(csc.getContainerId());
                    instance.setSolverId(csc.getSolverId());
                    instance.setSolverConfigFile(csc.getSolverConfigFile());
                    response = this.solverService.createSolver(csc.getContainerId(), csc.getSolverId(), instance);
                } else if (command instanceof GetSolversCommand) {
                    gss = (GetSolversCommand)command;
                    response = this.solverService.getSolvers(gss.getContainerId());
                } else if (command instanceof GetSolverStateCommand) {
                    gss = (GetSolverStateCommand)command;
                    response = this.solverService.getSolverState(gss.getContainerId(), gss.getSolverId());
                } else if (command instanceof GetBestSolutionCommand) {
                    gss = (GetBestSolutionCommand)command;
                    response = this.solverService.getBestSolution(gss.getContainerId(), gss.getSolverId());
                } else if (command instanceof UpdateSolverStateCommand) {
                    UpdateSolverStateCommand uss = (UpdateSolverStateCommand)command;
                    KieContainerInstanceImpl kc = this.context.getContainer(uss.getContainerId());
                    Marshaller marshaller = kc.getMarshaller(marshallingFormat);
                    SolverInstance si = (SolverInstance)marshaller.unmarshall(uss.getInstance(), SolverInstance.class);
                    response = this.solverService.updateSolverState(uss.getContainerId(), uss.getSolverId(), si);
                } else if (command instanceof DisposeSolverCommand) {
                    DisposeSolverCommand ds = (DisposeSolverCommand)command;
                    response = this.solverService.disposeSolver(ds.getContainerId(), ds.getSolverId());
                } else {
                    throw new IllegalStateException("Unsupported command: " + command);
                }
                logger.debug("Service returned response {}", response);
                responses.add(response);
            }
            catch (Throwable e) {
                logger.error("Error while processing {} command", (Object)command, (Object)e);
                responses.add(new ServiceResponse(ServiceResponse.ResponseType.FAILURE, e.getMessage()));
            }
        }
        logger.debug("About to return responses '{}'", responses);
        return new ServiceResponsesList(responses);
    }
}

