/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.optaplanner;

import java.util.ArrayList;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.optaplanner.CreateSolverCommand;
import org.kie.server.api.commands.optaplanner.DisposeSolverCommand;
import org.kie.server.api.commands.optaplanner.GetSolverCommand;
import org.kie.server.api.commands.optaplanner.GetSolverWithBestSolutionCommand;
import org.kie.server.api.commands.optaplanner.GetSolversCommand;
import org.kie.server.api.commands.optaplanner.SolvePlanningProblemCommand;
import org.kie.server.api.commands.optaplanner.TerminateSolverEarlyCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServerCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.optaplanner.SolverServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptaplannerCommandServiceImpl
implements KieContainerCommandService {
    private static final Logger logger = LoggerFactory.getLogger(OptaplannerCommandServiceImpl.class);
    private KieServerRegistry context;
    private SolverServiceBase solverService;

    public OptaplannerCommandServiceImpl(KieServerRegistry context, SolverServiceBase solverService) {
        this.context = context;
        this.solverService = solverService;
    }

    public ServiceResponse<String> callContainer(String containerId, String payload, MarshallingFormat marshallingFormat, String classType) {
        return null;
    }

    public ServiceResponsesList executeScript(CommandScript commands, MarshallingFormat marshallingFormat, String classType) {
        ArrayList<Object> responses = new ArrayList<Object>();
        for (KieServerCommand command : commands.getCommands()) {
            try {
                SolvePlanningProblemCommand uss;
                GetSolversCommand gss;
                String containerId;
                Object response = null;
                logger.debug("About to execute command: {}", (Object)command);
                if (command instanceof CreateSolverCommand) {
                    CreateSolverCommand csc = (CreateSolverCommand)command;
                    containerId = this.context.getContainerId(csc.getContainerId(), ContainerLocatorProvider.get().getLocator());
                    SolverInstance instance = new SolverInstance();
                    instance.setContainerId(containerId);
                    instance.setSolverId(csc.getSolverId());
                    instance.setSolverConfigFile(csc.getSolverConfigFile());
                    response = this.solverService.createSolver(containerId, csc.getSolverId(), instance);
                } else if (command instanceof GetSolversCommand) {
                    gss = (GetSolversCommand)command;
                    containerId = this.context.getContainerId(gss.getContainerId(), ContainerLocatorProvider.get().getLocator());
                    response = this.solverService.getSolvers(containerId);
                } else if (command instanceof GetSolverCommand) {
                    gss = (GetSolverCommand)command;
                    containerId = this.context.getContainerId(gss.getContainerId(), ContainerLocatorProvider.get().getLocator());
                    response = this.solverService.getSolver(containerId, gss.getSolverId());
                } else if (command instanceof GetSolverWithBestSolutionCommand) {
                    gss = (GetSolverWithBestSolutionCommand)command;
                    containerId = this.context.getContainerId(gss.getContainerId(), ContainerLocatorProvider.get().getLocator());
                    response = this.solverService.getSolverWithBestSolution(containerId, gss.getSolverId());
                } else if (command instanceof SolvePlanningProblemCommand) {
                    uss = (SolvePlanningProblemCommand)command;
                    containerId = this.context.getContainerId(uss.getContainerId(), ContainerLocatorProvider.get().getLocator());
                    KieContainerInstanceImpl kc = this.context.getContainer(containerId);
                    Marshaller marshaller = kc.getMarshaller(marshallingFormat);
                    Object planningProblem = marshaller.unmarshall(uss.getPlanningProblem(), Object.class);
                    response = this.solverService.solvePlanningProblem(containerId, uss.getSolverId(), planningProblem);
                } else if (command instanceof TerminateSolverEarlyCommand) {
                    uss = (TerminateSolverEarlyCommand)command;
                    containerId = this.context.getContainerId(uss.getContainerId(), ContainerLocatorProvider.get().getLocator());
                    response = this.solverService.terminateSolverEarly(containerId, uss.getSolverId());
                } else if (command instanceof DisposeSolverCommand) {
                    DisposeSolverCommand ds = (DisposeSolverCommand)command;
                    containerId = this.context.getContainerId(ds.getContainerId(), ContainerLocatorProvider.get().getLocator());
                    response = this.solverService.disposeSolver(containerId, ds.getSolverId());
                } else {
                    throw new IllegalStateException("Unsupported command: " + command);
                }
                logger.debug("Service returned response {}", response);
                responses.add(response);
            }
            catch (Throwable e) {
                logger.error("Error while processing {} command", (Object)command, (Object)e);
                responses.add(new ServiceResponse(ServiceResponse.ResponseType.FAILURE, e.getMessage()));
            }
        }
        logger.debug("About to return responses '{}'", responses);
        return new ServiceResponsesList(responses);
    }
}

