/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Gauge;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusDeploymentEventListener
implements DeploymentEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusDeploymentEventListener.class);
    private static final Gauge runningDeployments = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_deployments_active_total")).help("Kie Server Active Deployments")).labelNames(new String[]{"deployment_id"})).register();

    public void onDeploy(DeploymentEvent event) {
        LOGGER.debug("OnDeploy: {}", (Object)event);
        ((Gauge.Child)runningDeployments.labels(new String[]{event.getDeploymentId()})).inc();
    }

    public void onUnDeploy(DeploymentEvent event) {
        LOGGER.debug("OnUnDeploy: {}", (Object)event);
        ((Gauge.Child)runningDeployments.labels(new String[]{event.getDeploymentId()})).dec();
    }

    public void onActivate(DeploymentEvent event) {
    }

    public void onDeactivate(DeploymentEvent event) {
    }
}

