/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Histogram;
import org.drools.core.event.rule.impl.AfterActivationFiredEventImpl;
import org.drools.core.event.rule.impl.BeforeActivationFiredEventImpl;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsDroolsListener
implements AgendaEventListener {
    private static final Logger logger = LoggerFactory.getLogger(PrometheusMetricsDroolsListener.class);
    private final PrometheusMetrics metrics;
    private final String kieSessionId;
    private final KieContainerInstance containerInstance;

    public PrometheusMetricsDroolsListener(PrometheusMetrics metrics, String kieSessionId, KieContainerInstance containerInstance) {
        this.metrics = metrics;
        this.kieSessionId = kieSessionId;
        this.containerInstance = containerInstance;
    }

    public void matchCreated(MatchCreatedEvent event) {
    }

    public void matchCancelled(MatchCancelledEvent event) {
    }

    public void beforeMatchFired(BeforeMatchFiredEvent event) {
        long nanoTime = System.nanoTime();
        BeforeActivationFiredEventImpl impl = this.getBeforeImpl(event);
        impl.setTimestamp(nanoTime);
    }

    public void afterMatchFired(AfterMatchFiredEvent event) {
        AfterActivationFiredEventImpl afterImpl = this.getAfterImpl(event);
        BeforeActivationFiredEventImpl beforeImpl = this.getBeforeImpl(afterImpl.getBeforeMatchFiredEvent());
        long startTime = beforeImpl.getTimestamp();
        long elapsed = System.nanoTime() - startTime;
        String ruleName = event.getMatch().getRule().getName();
        ReleaseId releaseId = this.containerInstance.getResource().getReleaseId();
        ((Histogram.Child)this.metrics.getDroolsEvaluationTimeHistogram().labels(new String[]{this.containerInstance.getContainerId(), this.kieSessionId, releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion(), ruleName})).observe((double)elapsed);
        if (logger.isDebugEnabled()) {
            logger.debug("Elapsed time: " + elapsed);
        }
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    public BeforeActivationFiredEventImpl getBeforeImpl(BeforeMatchFiredEvent e) {
        return (BeforeActivationFiredEventImpl)e;
    }

    public AfterActivationFiredEventImpl getAfterImpl(AfterMatchFiredEvent e) {
        return (AfterActivationFiredEventImpl)e;
    }
}

