/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kie.api.task.model.Status;
import org.kie.server.api.model.taskassigning.PlanningTask;
import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.api.model.taskassigning.util.StatusConverter;
import org.kie.server.services.taskassigning.core.model.ModelConstants;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.core.model.TaskOrUser;
import org.kie.server.services.taskassigning.planning.SolverHandlerContext;
import org.kie.server.services.taskassigning.planning.util.IndexedElement;
import org.kie.server.services.taskassigning.planning.util.TaskUtil;
import org.kie.server.services.taskassigning.planning.util.UserUtil;
import org.kie.server.services.taskassigning.user.system.api.User;

public class SolutionBuilder {
    private List<TaskData> taskDataList;
    private List<User> externalUsers;
    private SolverHandlerContext context;

    private SolutionBuilder() {
    }

    public static SolutionBuilder create() {
        return new SolutionBuilder();
    }

    public SolutionBuilder withTasks(List<TaskData> taskDataList) {
        this.taskDataList = taskDataList;
        return this;
    }

    public SolutionBuilder withUsers(List<User> externalUsers) {
        this.externalUsers = externalUsers;
        return this;
    }

    public SolutionBuilder withContext(SolverHandlerContext context) {
        this.context = context;
        return this;
    }

    public TaskAssigningSolution build() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        HashMap<String, List> assignedTasksByUserId = new HashMap<String, List>();
        Map usersById = UserUtil.filterDuplicates(this.externalUsers).filter(externalUser -> !ModelConstants.IS_PLANNING_USER.test(externalUser.getId())).map(UserUtil::fromExternalUser).collect(Collectors.toMap(org.kie.server.services.taskassigning.core.model.User::getEntityId, Function.identity()));
        usersById.put(ModelConstants.PLANNING_USER.getEntityId(), ModelConstants.PLANNING_USER);
        this.taskDataList.forEach(taskData -> {
            this.context.setTaskChangeTime(taskData.getTaskId(), taskData.getLastModificationDate());
            Task task = TaskUtil.fromTaskData(taskData);
            Status status = StatusConverter.convertFromString((String)task.getStatus());
            switch (status) {
                case Ready: {
                    tasks.add(task);
                    break;
                }
                case Reserved: 
                case InProgress: 
                case Suspended: {
                    if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{taskData.getActualOwner()})) break;
                    tasks.add(task);
                    PlanningTask planningTask = taskData.getPlanningTask();
                    if (planningTask != null && taskData.getActualOwner().equals(planningTask.getAssignedUser())) {
                        boolean pinned = Status.InProgress == status || Status.Suspended == status || planningTask.getPublished() != false || !usersById.containsKey(taskData.getActualOwner());
                        SolutionBuilder.addTaskToUser(assignedTasksByUserId, task, planningTask.getAssignedUser(), planningTask.getIndex(), pinned);
                        break;
                    }
                    boolean pinned = Status.Reserved == status && !ModelConstants.IS_PLANNING_USER.test(taskData.getActualOwner()) || Status.InProgress == status || Status.Suspended == status;
                    SolutionBuilder.addTaskToUser(assignedTasksByUserId, task, taskData.getActualOwner(), -1, pinned);
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("Value: " + taskData.getStatus() + " is out of range in current switch");
                }
            }
        });
        assignedTasksByUserId.forEach((key, assignedTasks) -> {
            org.kie.server.services.taskassigning.core.model.User user = (org.kie.server.services.taskassigning.core.model.User)usersById.get(key);
            if (user == null) {
                user = new org.kie.server.services.taskassigning.core.model.User((long)key.hashCode(), key);
                usersById.put((String)key, user);
            }
            List<Task> userTasks = assignedTasks.stream().map(IndexedElement::getElement).collect(Collectors.toList());
            SolutionBuilder.addTasksToUser(user, userTasks);
        });
        tasks.add(ModelConstants.DUMMY_TASK);
        ArrayList users = new ArrayList(usersById.values());
        return new TaskAssigningSolution(-1L, users, tasks);
    }

    private static void addTasksToUser(org.kie.server.services.taskassigning.core.model.User user, List<Task> tasks) {
        org.kie.server.services.taskassigning.core.model.User previousTask = user;
        for (Task nextTask : tasks) {
            previousTask.setNextTask(nextTask);
            nextTask.setStartTimeInMinutes(previousTask.getEndTimeInMinutes());
            nextTask.setEndTime(Integer.valueOf(nextTask.getStartTimeInMinutes() + nextTask.getDurationInMinutes()));
            nextTask.setPreviousTaskOrUser((TaskOrUser)previousTask);
            nextTask.setUser(user);
            previousTask = nextTask;
        }
    }

    private static void addTaskToUser(Map<String, List<IndexedElement<Task>>> tasksByUser, Task task, String actualOwner, int index, boolean pinned) {
        task.setPinned(pinned);
        List userAssignedTasks = tasksByUser.computeIfAbsent(actualOwner, key -> new ArrayList());
        IndexedElement.addInOrder(userAssignedTasks, new IndexedElement<Task>(task, index, task.isPinned()));
    }
}

