/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.runtime;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.api.query.QueryMapperRegistry;
import org.jbpm.services.api.query.QueryResultMapper;
import org.jbpm.services.api.query.QueryService;
import org.jbpm.services.api.query.model.QueryParam;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Status;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.taskassigning.LocalDateTimeValue;
import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.api.model.taskassigning.TaskInputVariablesReadMode;
import org.kie.server.api.model.taskassigning.util.StatusConverter;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.taskassigning.runtime.query.AbstractTaskAssigningQueryMapper;

public class TaskAssigningRuntimeServiceQueryHelper {
    private static final String TASK_ASSIGNING_TASKS_WITH_POTENTIAL_OWNERS_AND_PLANNING_TASK = "task-assigning-tasks-with-potential-owners-and-planning-task";
    private static final String TASK_ASSIGNING_TASKS_WITH_PLANNING_TASK_OPTIMIZED = "task-assigning-tasks-with-planning-task-optimized";
    private KieServerRegistry registry;
    private UserTaskService userTaskService;
    private QueryService queryService;

    public TaskAssigningRuntimeServiceQueryHelper(KieServerRegistry registry, UserTaskService userTaskService, QueryService queryService) {
        this.registry = registry;
        this.userTaskService = userTaskService;
        this.queryService = queryService;
    }

    public List<TaskData> executeFindTasksQuery(Map<String, Object> params) {
        List<QueryParam> queryParams = this.buildQueryParams(params);
        Integer page = params.containsKey("page") ? (Integer)params.get("page") : 0;
        Integer pageSize = params.containsKey("pageSize") ? (Integer)params.get("pageSize") : 10;
        String loadVariablesMode = (String)params.get("inputVariablesMode");
        QueryContext queryContext = new QueryContext(Integer.valueOf(page * pageSize), pageSize, AbstractTaskAssigningQueryMapper.TASK_QUERY_COLUMN.TASK_ID.columnName(), true);
        AbstractTaskAssigningQueryMapper resultMapper = (AbstractTaskAssigningQueryMapper)QueryMapperRegistry.get().mapperFor("TaskAssigningTaskDataQueryMapper", null);
        List result = (List)this.executeQuery(this.queryService, TASK_ASSIGNING_TASKS_WITH_POTENTIAL_OWNERS_AND_PLANNING_TASK, resultMapper, queryContext, queryParams.toArray(new QueryParam[0]));
        Optional<Object> loadInputVariables = Optional.empty();
        if (TaskInputVariablesReadMode.READ_FOR_ALL.name().equals(loadVariablesMode)) {
            loadInputVariables = Optional.of(taskData -> true);
        } else if (TaskInputVariablesReadMode.READ_FOR_ACTIVE_TASKS_WITH_NO_PLANNING_ENTITY.name().equals(loadVariablesMode)) {
            Predicate<TaskData> isActive = taskData -> {
                if (taskData.getPlanningTask() != null) {
                    return false;
                }
                Status taskStatus = StatusConverter.convertFromString((String)taskData.getStatus());
                return taskStatus == Status.Created || taskStatus == Status.Ready || taskStatus == Status.Reserved || taskStatus == Status.InProgress || taskStatus == Status.Suspended;
            };
            loadInputVariables = Optional.of(isActive);
        }
        loadInputVariables.ifPresent(taskDataPredicate -> result.stream().filter(taskDataPredicate).forEach(taskData -> taskData.setInputData(this.readTaskVariables((TaskData)taskData))));
        return result;
    }

    public List<TaskData> readTasksDataSummary(long fromTaskId, List<String> status, int pageSize) {
        boolean finished = false;
        ArrayList<TaskData> result = new ArrayList<TaskData>();
        long taskId = fromTaskId;
        while (!finished) {
            List<TaskData> partialResult = this.executeOptimizedFindTasksDataSummaryQuery(taskId, status, 0, pageSize);
            if (partialResult.isEmpty()) {
                finished = true;
                continue;
            }
            taskId = partialResult.get(partialResult.size() - 1).getTaskId() + 1L;
            result.addAll(partialResult);
        }
        return result;
    }

    private List<TaskData> executeOptimizedFindTasksDataSummaryQuery(Long fromTaskId, List<String> status, int page, int pageSize) {
        QueryContext queryContext = new QueryContext(Integer.valueOf(page * pageSize), Integer.valueOf(pageSize), AbstractTaskAssigningQueryMapper.TASK_QUERY_COLUMN.TASK_ID.columnName(), true);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fromTaskId", fromTaskId);
        params.put("status", status);
        List<QueryParam> queryParams = this.buildQueryParams(params);
        AbstractTaskAssigningQueryMapper resultMapper = (AbstractTaskAssigningQueryMapper)QueryMapperRegistry.get().mapperFor("TaskAssigningTaskDataSummaryQueryMapper", null);
        return (List)this.executeQuery(this.queryService, TASK_ASSIGNING_TASKS_WITH_PLANNING_TASK_OPTIMIZED, resultMapper, queryContext, queryParams.toArray(new QueryParam[0]));
    }

    private Map<String, Object> readTaskVariables(TaskData taskData) {
        KieContainerInstanceImpl container = this.registry.getContainer(taskData.getContainerId());
        if (container == null || container.getStatus() != KieContainerStatus.STARTED && container.getStatus() != KieContainerStatus.DEACTIVATED) {
            throw new KieServicesException("Container " + taskData.getContainerId() + " is not available to serve requests");
        }
        Map variables = this.userTaskService.getTaskInputContentByTaskId(taskData.getContainerId(), taskData.getTaskId());
        variables = variables == null ? new HashMap() : variables;
        return variables.entrySet().stream().filter(entry -> TaskAssigningRuntimeServiceQueryHelper.isSimpleTypeValue(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean isSimpleTypeValue(Object value) {
        return ClassUtils.isPrimitiveWrapper(value.getClass()) || value instanceof Date || value instanceof String;
    }

    <T> T executeQuery(QueryService queryService, String queryName, QueryResultMapper<T> resultMapper, QueryContext queryContext, QueryParam[] params) {
        return (T)queryService.query(queryName, resultMapper, queryContext, params);
    }

    List<QueryParam> buildQueryParams(Map<String, Object> params) {
        List status;
        LocalDateTime fromLastModificationDate;
        ArrayList<QueryParam> queryParams = new ArrayList<QueryParam>();
        if (params.get("fromTaskId") instanceof Number) {
            Long fromTaskId = ((Number)params.get("fromTaskId")).longValue();
            queryParams.add(QueryParam.greaterOrEqualTo((String)AbstractTaskAssigningQueryMapper.TASK_QUERY_COLUMN.TASK_ID.columnName(), (Comparable)fromTaskId));
        }
        if (params.get("toTaskId") instanceof Number) {
            Long toTaskId = ((Number)params.get("toTaskId")).longValue();
            queryParams.add(QueryParam.lowerOrEqualTo((String)AbstractTaskAssigningQueryMapper.TASK_QUERY_COLUMN.TASK_ID.columnName(), (Comparable)toTaskId));
        }
        if (params.containsKey("fromLastModificationDate") && (fromLastModificationDate = params.get("fromLastModificationDate") instanceof LocalDateTimeValue ? ((LocalDateTimeValue)params.get("fromLastModificationDate")).getValue() : (LocalDateTime)params.get("fromLastModificationDate")) != null) {
            Date lastModificationDateValue = Date.from(fromLastModificationDate.atZone(ZoneId.systemDefault()).toInstant());
            queryParams.add(QueryParam.greaterOrEqualTo((String)AbstractTaskAssigningQueryMapper.TASK_QUERY_COLUMN.LAST_MODIFICATION_DATE.columnName(), (Comparable)lastModificationDateValue));
        }
        if ((status = (List)params.get("status")) != null && !status.isEmpty()) {
            queryParams.add(QueryParam.equalsTo((String)AbstractTaskAssigningQueryMapper.TASK_QUERY_COLUMN.STATUS.columnName(), (Comparable[])((Comparable[])status.toArray(new String[0]))));
        }
        return queryParams;
    }
}

