/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.runtime.query;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jbpm.services.api.query.QueryResultMapper;
import org.kie.server.api.model.taskassigning.OrganizationalEntity;
import org.kie.server.api.model.taskassigning.PlanningTask;
import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.services.taskassigning.runtime.query.AbstractTaskAssigningQueryMapper;

public class TaskAssigningTaskDataWithPotentialOwnersQueryMapper
extends AbstractTaskAssigningQueryMapper<TaskData> {
    public static final String NAME = "TaskAssigningTaskDataWithPotentialOwnersQueryMapper";

    public static TaskAssigningTaskDataWithPotentialOwnersQueryMapper get() {
        return new TaskAssigningTaskDataWithPotentialOwnersQueryMapper();
    }

    @Override
    protected TaskData createInstance() {
        return TaskData.builder().potentialOwners(new HashSet()).build();
    }

    @Override
    protected boolean readPotentialOwners() {
        return true;
    }

    @Override
    protected void setInstanceValues(TaskData row, Long taskId, Date createdOn, Long processInstanceId, String processId, String deploymentId, String status, Integer priority, String taskName, Date lastModificationDate, String actualOwner, String assignedUser, Integer taskIndex, Integer published) {
        row.setTaskId(taskId);
        row.setCreatedOn(TaskAssigningTaskDataWithPotentialOwnersQueryMapper.toLocalDateTime(createdOn));
        row.setProcessInstanceId(processInstanceId);
        row.setProcessId(processId);
        row.setContainerId(deploymentId);
        row.setStatus(status);
        row.setPriority(priority);
        row.setName(taskName);
        row.setLastModificationDate(TaskAssigningTaskDataWithPotentialOwnersQueryMapper.toLocalDateTime(lastModificationDate));
        row.setActualOwner(actualOwner);
        if (assignedUser != null || taskIndex != null) {
            row.setPlanningTask(PlanningTask.builder().taskId(taskId).assignedUser(assignedUser).index(taskIndex).published(Boolean.valueOf(published != null && published == 1)).build());
        }
    }

    @Override
    protected void addPotentialOwner(TaskData taskRow, String potentialOwnerId, String potentialOwnerType) {
        taskRow.getPotentialOwners().add(OrganizationalEntity.builder().name(potentialOwnerId).type(potentialOwnerType).build());
    }

    public Class<?> getType() {
        return TaskData.class;
    }

    public String getName() {
        return NAME;
    }

    public QueryResultMapper<List<TaskData>> forColumnMapping(Map<String, String> map) {
        return TaskAssigningTaskDataWithPotentialOwnersQueryMapper.get();
    }
}

