/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.kie.smoke.wb.util.handler.AbstractResponseHandler;
import org.kie.smoke.wb.util.handler.JsonResponseHandler;
import org.kie.smoke.wb.util.handler.XmlResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtil {
    private static Logger logger = LoggerFactory.getLogger(RestUtil.class);

    private static String basicAuthenticationHeader(String user, String password) {
        String token = user + ":" + password;
        try {
            return "BASIC " + DatatypeConverter.printBase64Binary((byte[])token.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Cannot encode with UTF-8", ex);
        }
    }

    private static <T> ResponseHandler<T> createResponseHandler(String mediaType, int status, Class ... responseTypes) {
        AbstractResponseHandler rh = null;
        if ("application/xml".equals(mediaType)) {
            rh = new XmlResponseHandler(status, responseTypes);
        } else if ("application/json".equals(mediaType)) {
            rh = new JsonResponseHandler(status, responseTypes);
        } else {
            Assert.fail((String)("Unexpected media type: " + mediaType));
        }
        return rh;
    }

    private static String createBaseUriString(URL deploymentUrl, String relativeUrl) {
        String uriStr = null;
        try {
            uriStr = deploymentUrl.toURI() + relativeUrl;
        }
        catch (URISyntaxException urise) {
            RestUtil.logAndFail("Invalid uri :" + deploymentUrl.toString(), urise);
        }
        return uriStr;
    }

    private static void logOp(String op, String uri) {
        logger.debug("[" + op + "] " + uri);
    }

    private static void logOp(String op, Object entity, String uri) {
        logger.debug("[" + op + "] (" + entity.getClass().getSimpleName() + ") " + uri);
    }

    public static void logAndFail(String msg, Exception e) {
        logger.error(msg, (Throwable)e);
        Assert.fail((String)(msg + ": " + e.getMessage()));
    }

    public static <T, G> T get(URL deploymentUrl, String relativeUrl, String mediaType, int status, String user, String password, Class ... responseTypes) {
        String uriStr = RestUtil.createBaseUriString(deploymentUrl, relativeUrl);
        ResponseHandler<T> rh = RestUtil.createResponseHandler(mediaType, status, responseTypes);
        Request request = Request.Get((String)uriStr).addHeader("Accept", mediaType.toString()).addHeader("Authorization", RestUtil.basicAuthenticationHeader(user, password));
        Response resp = null;
        try {
            RestUtil.logOp("GET", uriStr);
            resp = request.execute();
        }
        catch (Exception e) {
            RestUtil.logAndFail("[GET] " + uriStr, e);
        }
        try {
            return (T)resp.handleResponse(rh);
        }
        catch (Exception e) {
            RestUtil.logAndFail("Failed retrieving response from [GET] " + uriStr, e);
            return null;
        }
    }

    public static <T, G> T getQuery(URL deploymentUrl, String relativeUrl, String mediaType, int status, String user, String password, Map<String, String> queryParams, Class ... responseTypes) {
        URIBuilder uriBuilder = null;
        try {
            String uriStr = RestUtil.createBaseUriString(deploymentUrl, relativeUrl);
            uriBuilder = new URIBuilder(uriStr);
        }
        catch (URISyntaxException urise) {
            RestUtil.logAndFail("Invalid uri :" + deploymentUrl.toString(), urise);
        }
        for (Map.Entry<String, String> paramEntry : queryParams.entrySet()) {
            uriBuilder.addParameter(paramEntry.getKey(), paramEntry.getValue());
        }
        URI uri = null;
        String uriStr = null;
        try {
            uri = uriBuilder.build();
            uriStr = uri.toString();
        }
        catch (URISyntaxException urise) {
            RestUtil.logAndFail("Invalid uri!", urise);
        }
        ResponseHandler<T> rh = RestUtil.createResponseHandler(mediaType, status, responseTypes);
        Request request = Request.Get((URI)uri).addHeader("Accept", mediaType.toString()).addHeader("Authorization", RestUtil.basicAuthenticationHeader(user, password));
        Response resp = null;
        try {
            RestUtil.logOp("GET", uriStr);
            resp = request.execute();
        }
        catch (Exception e) {
            RestUtil.logAndFail("[GET] " + uriStr, e);
        }
        try {
            return (T)resp.handleResponse(rh);
        }
        catch (Exception e) {
            RestUtil.logAndFail("Failed retrieving response from [GET] " + uriStr, e);
            return null;
        }
    }

    public static <T> T postEntity(URL deploymentUrl, String relativeUrl, int status, String user, String password, Class[] classes, Object entity, Class<T> ... responseTypes) {
        String uriStr = RestUtil.createBaseUriString(deploymentUrl, relativeUrl);
        String mediaType = "application/xml";
        ResponseHandler<T> rh = RestUtil.createResponseHandler(mediaType, status, responseTypes);
        XmlResponseHandler xrh = (XmlResponseHandler)rh;
        xrh.addExtraJaxbClasses(classes);
        String entityStr = xrh.serialize(entity);
        StringEntity bodyEntity = null;
        try {
            bodyEntity = new StringEntity(entityStr);
        }
        catch (UnsupportedEncodingException uee) {
            RestUtil.logAndFail("Unable to encode serialized " + entity.getClass().getSimpleName() + " entity", uee);
        }
        Request request = Request.Post((String)uriStr).body((HttpEntity)bodyEntity).addHeader("Content-Type", mediaType.toString()).addHeader("Accept", mediaType.toString()).addHeader("Authorization", RestUtil.basicAuthenticationHeader(user, password));
        Response resp = null;
        try {
            RestUtil.logOp("POST", entity, uriStr);
            resp = request.execute();
        }
        catch (Exception e) {
            RestUtil.logAndFail("[GET] " + uriStr, e);
        }
        try {
            return (T)resp.handleResponse(rh);
        }
        catch (Exception e) {
            RestUtil.logAndFail("Failed retrieving response from [GET] " + uriStr, e);
            return null;
        }
    }

    public static <T> T postEntity(URL deploymentUrl, String relativeUrl, String mediaType, int status, String user, String password, Object entity, Class<T> ... responseTypes) {
        String uriStr = RestUtil.createBaseUriString(deploymentUrl, relativeUrl);
        ResponseHandler<T> rh = RestUtil.createResponseHandler(mediaType, status, responseTypes);
        String entityStr = ((AbstractResponseHandler)rh).serialize(entity);
        StringEntity bodyEntity = null;
        try {
            bodyEntity = new StringEntity(entityStr);
        }
        catch (UnsupportedEncodingException uee) {
            RestUtil.logAndFail("Unable to encode serialized " + entity.getClass().getSimpleName() + " entity", uee);
        }
        Request request = Request.Post((String)uriStr).body((HttpEntity)bodyEntity).addHeader("Content-Type", mediaType.toString()).addHeader("Accept", mediaType.toString()).addHeader("Authorization", RestUtil.basicAuthenticationHeader(user, password));
        Response resp = null;
        try {
            RestUtil.logOp("POST", entity, uriStr);
            resp = request.execute();
        }
        catch (Exception e) {
            RestUtil.logAndFail("[GET] " + uriStr, e);
        }
        try {
            return (T)resp.handleResponse(rh);
        }
        catch (Exception e) {
            RestUtil.logAndFail("Failed retrieving response from [GET] " + uriStr, e);
            return null;
        }
    }

    public static <T> T postEntity(URL deploymentUrl, String relativeUrl, String mediaType, int status, String user, String password, double timeoutInSecs, Object entity, Class<T> ... responseTypes) {
        String uriStr = RestUtil.createBaseUriString(deploymentUrl, relativeUrl);
        ResponseHandler<T> rh = RestUtil.createResponseHandler(mediaType, status, responseTypes);
        String entityStr = ((AbstractResponseHandler)rh).serialize(entity);
        StringEntity bodyEntity = null;
        try {
            bodyEntity = new StringEntity(entityStr);
        }
        catch (UnsupportedEncodingException uee) {
            RestUtil.logAndFail("Unable to encode serialized " + entity.getClass().getSimpleName() + " entity", uee);
        }
        Request request = Request.Post((String)uriStr).body((HttpEntity)bodyEntity).addHeader("Content-Type", mediaType.toString()).addHeader("Accept", mediaType.toString()).addHeader("Authorization", RestUtil.basicAuthenticationHeader(user, password));
        Response resp = null;
        long before = 0L;
        long after = 0L;
        try {
            RestUtil.logOp("POST", entity, uriStr);
            before = System.currentTimeMillis();
            resp = request.execute();
            after = System.currentTimeMillis();
        }
        catch (Exception e) {
            RestUtil.logAndFail("[GET] " + uriStr, e);
        }
        long duration = after - before;
        Assert.assertTrue((String)("Timeout exceeded " + timeoutInSecs + " secs: " + (double)duration / 1000.0 + " secs"), ((double)duration < timeoutInSecs * 1000.0 ? 1 : 0) != 0);
        try {
            return (T)resp.handleResponse(rh);
        }
        catch (Exception e) {
            RestUtil.logAndFail("Failed retrieving response from [GET] " + uriStr, e);
            return null;
        }
    }

    public static <T> T post(URL deploymentUrl, String relativeUrl, String mediaType, int status, String user, String password, double timeoutInSecs, Class<T> ... responseTypes) {
        String uriStr = RestUtil.createBaseUriString(deploymentUrl, relativeUrl);
        ResponseHandler<T> rh = RestUtil.createResponseHandler(mediaType, status, responseTypes);
        Request request = Request.Post((String)uriStr).addHeader("Content-Type", mediaType.toString()).addHeader("Accept", mediaType.toString()).addHeader("Authorization", RestUtil.basicAuthenticationHeader(user, password));
        Response resp = null;
        long before = 0L;
        long after = 0L;
        try {
            RestUtil.logOp("POST", uriStr);
            before = System.currentTimeMillis();
            resp = request.execute();
            after = System.currentTimeMillis();
        }
        catch (Exception e) {
            RestUtil.logAndFail("[GET] " + uriStr, e);
        }
        long duration = after - before;
        Assert.assertTrue((String)("Timeout exceeded " + timeoutInSecs + " secs: " + (double)duration / 1000.0 + " secs"), ((double)duration < timeoutInSecs * 1000.0 ? 1 : 0) != 0);
        try {
            return (T)resp.handleResponse(rh);
        }
        catch (Exception e) {
            RestUtil.logAndFail("Failed retrieving response from [GET] " + uriStr, e);
            return null;
        }
    }

    public static <T> T post(URL deploymentUrl, String relativeUrl, String mediaType, int status, String user, String password, Class<T> ... responseTypes) {
        String uriStr = RestUtil.createBaseUriString(deploymentUrl, relativeUrl);
        ResponseHandler<T> rh = RestUtil.createResponseHandler(mediaType, status, responseTypes);
        Request request = Request.Post((String)uriStr).addHeader("Accept", mediaType.toString()).addHeader("Authorization", RestUtil.basicAuthenticationHeader(user, password));
        Response resp = null;
        try {
            RestUtil.logOp("POST", uriStr);
            resp = request.execute();
        }
        catch (Exception e) {
            RestUtil.logAndFail("[GET] " + uriStr, e);
        }
        try {
            return (T)resp.handleResponse(rh);
        }
        catch (Exception e) {
            RestUtil.logAndFail("Failed retrieving response from [GET] " + uriStr, e);
            return null;
        }
    }

    public static <T> T postForm(URL deploymentUrl, String relativeUrl, String mediaType, int status, String user, String password, Map<String, String> formParams, Class<T> ... responseTypes) {
        String uriStr = RestUtil.createBaseUriString(deploymentUrl, relativeUrl);
        Form formContent = Form.form();
        for (Map.Entry<String, String> entry : formParams.entrySet()) {
            formContent.add(entry.getKey(), entry.getValue());
        }
        Request request = Request.Post((String)uriStr).addHeader("Content-Type", mediaType.toString()).addHeader("Accept", mediaType.toString()).addHeader("Authorization", RestUtil.basicAuthenticationHeader(user, password)).bodyForm((Iterable)formContent.build());
        Response resp = null;
        try {
            RestUtil.logOp("POST", uriStr);
            resp = request.execute();
        }
        catch (Exception e) {
            RestUtil.logAndFail("[GET] " + uriStr, e);
        }
        ResponseHandler<T> rh = RestUtil.createResponseHandler(mediaType, status, responseTypes);
        try {
            return (T)resp.handleResponse(rh);
        }
        catch (Exception e) {
            RestUtil.logAndFail("Failed retrieving response from [GET] " + uriStr, e);
            return null;
        }
    }

    public static <T, G> T delete(URL deploymentUrl, String relativeUrl, String mediaType, int status, String user, String password, Class ... responseTypes) {
        String uriStr = RestUtil.createBaseUriString(deploymentUrl, relativeUrl);
        ResponseHandler<T> rh = RestUtil.createResponseHandler(mediaType, status, responseTypes);
        Request request = Request.Delete((String)uriStr).addHeader("Accept", mediaType.toString()).addHeader("Authorization", RestUtil.basicAuthenticationHeader(user, password));
        Response resp = null;
        try {
            RestUtil.logOp("DELETE", uriStr);
            resp = request.execute();
        }
        catch (Exception e) {
            RestUtil.logAndFail("[GET] " + uriStr, e);
        }
        try {
            return (T)resp.handleResponse(rh);
        }
        catch (Exception e) {
            RestUtil.logAndFail("Failed retrieving response from [GET] " + uriStr, e);
            return null;
        }
    }
}

