/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.util.handler;

import org.apache.http.entity.ContentType;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.kie.smoke.wb.util.RestUtil;
import org.kie.smoke.wb.util.handler.AbstractResponseHandler;

public class JsonResponseHandler<T, P>
extends AbstractResponseHandler<T, P> {
    private final ObjectMapper om = new ObjectMapper();

    public JsonResponseHandler(int status, Class<T> ... returnTypes) {
        super(ContentType.APPLICATION_JSON, status, returnTypes);
    }

    public JsonResponseHandler(Class<T> ... returnTypes) {
        super(ContentType.APPLICATION_JSON, returnTypes);
    }

    @Override
    protected T deserialize(String content) {
        if (this.parameterType == null) {
            try {
                Object obj = this.om.readValue(content, this.returnType);
                if (logger.isTraceEnabled()) {
                    Object prettyPrintObj = this.om.readValue(content, Object.class);
                    String prettyContent = this.om.writerWithDefaultPrettyPrinter().writeValueAsString(prettyPrintObj);
                    logger.trace("JSON < |\n{}", (Object)prettyContent);
                }
                return (T)obj;
            }
            catch (Exception e) {
                RestUtil.logAndFail(this.returnType.getSimpleName() + " deserialization failed", e);
            }
        } else {
            JavaType genericsType = this.om.getTypeFactory().constructParametricType(this.returnType, new Class[]{this.parameterType});
            try {
                return (T)this.om.readValue(content, genericsType);
            }
            catch (Exception e) {
                RestUtil.logAndFail(this.returnType.getSimpleName() + "<" + this.parameterType.getSimpleName() + ">" + " deserialization failed", e);
            }
        }
        return null;
    }

    @Override
    public String serialize(Object entity) {
        String out = null;
        try {
            out = this.om.writeValueAsString(entity);
            if (logger.isTraceEnabled()) {
                logger.trace("JSON > |\n{} ", (Object)this.om.writerWithDefaultPrettyPrinter().writeValueAsString(entity));
            }
        }
        catch (Exception e) {
            RestUtil.logAndFail(entity.getClass().getSimpleName() + " instance serialization failed", e);
        }
        return out;
    }
}

