/*
 * Decompiled with CFR 0.152.
 */
package org.kie.smoke.wb.util.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponseHandler<T, P>
implements ResponseHandler<T> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractResponseHandler.class);
    protected final Class<T> returnType;
    protected Class<P> parameterType = null;
    private int status = 200;
    protected final ContentType myContentType;

    public AbstractResponseHandler(ContentType type, int status, Class<T> ... returnTypes) {
        this.myContentType = type;
        this.status = status;
        if (returnTypes != null && returnTypes.length > 0) {
            this.returnType = returnTypes[0];
            if (returnTypes.length == 2) {
                this.parameterType = returnTypes[1];
            }
        } else {
            this.returnType = null;
        }
    }

    public AbstractResponseHandler(ContentType type, Class<T> ... returnTypes) {
        this.myContentType = type;
        if (returnTypes != null && returnTypes.length > 0) {
            this.returnType = returnTypes[0];
            if (returnTypes.length == 2) {
                this.parameterType = returnTypes[1];
            }
        } else {
            this.returnType = null;
        }
    }

    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        int numCharsRead;
        Object buffer;
        int responseStatus = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((String)"Empty response content", (Object)entity);
        ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
        Charset charset = contentType.getCharset();
        InputStream contentStream = entity.getContent();
        Reader reader = charset != null ? new InputStreamReader(contentStream, charset) : new InputStreamReader(contentStream);
        reader = new BufferedReader(reader);
        if (this.status != responseStatus) {
            StringWriter writer;
            if (!this.myContentType.equals(contentType)) {
                if (contentType.toString().contains("text/html")) {
                    int n;
                    writer = new StringWriter();
                    buffer = new char[1024];
                    while ((n = reader.read((char[])buffer)) != -1) {
                        writer.write((char[])buffer, 0, n);
                    }
                    String content = writer.toString();
                    Document doc = Jsoup.parse((String)content);
                    String errorBody = doc.body().text();
                    Assert.fail((String)(responseStatus + ": " + errorBody + " [expected " + this.status + "]"));
                } else {
                    Assert.assertEquals((String)("Response status [content type: " + contentType.toString() + "]"), (long)this.status, (long)responseStatus);
                }
            } else if (contentType.toString().contains("text/plain")) {
                int n;
                writer = new StringWriter();
                buffer = new char[1024];
                while ((n = reader.read((char[])buffer)) != -1) {
                    writer.write((char[])buffer, 0, n);
                }
                String errorBody = writer.toString();
                Assert.fail((String)(responseStatus + ": " + errorBody + " [expected " + this.status + "]"));
            } else {
                Assert.assertEquals((String)"Response status", (long)this.status, (long)responseStatus);
            }
        }
        char[] arr = new char[8192];
        buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            ((StringBuilder)buffer).append(arr, 0, numCharsRead);
        }
        reader.close();
        if (this.returnType != null) {
            return this.deserialize(((StringBuilder)buffer).toString());
        }
        return null;
    }

    protected abstract T deserialize(String var1);

    public abstract String serialize(Object var1);
}

