/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.ValidationError;

public class DataSetConstraints<T> {
    public static final int ERROR_COLUMN_TYPE = 100;
    public static final int ERROR_COLUMN_NUMBER = 101;
    protected List<ColumnType[]> columnTypeList = new ArrayList<ColumnType[]>();
    protected int minColumns = -1;
    protected int maxColumns = -1;
    protected boolean extraColumnsAllowed = false;
    protected ColumnType extraColumnsType = null;

    public ColumnType[] getColumnTypes() {
        if (this.columnTypeList.isEmpty()) {
            return null;
        }
        return this.columnTypeList.get(0);
    }

    public ColumnType[] getColumnTypes(int numberOfColumns) {
        if (this.columnTypeList.isEmpty()) {
            return null;
        }
        for (ColumnType[] types : this.columnTypeList) {
            if (types.length != numberOfColumns) continue;
            return types;
        }
        return this.columnTypeList.get(0);
    }

    public T setColumnTypes(ColumnType[] ... typeList) {
        this.columnTypeList.clear();
        if (typeList != null) {
            for (ColumnType[] types : typeList) {
                this._checkSizes(this.minColumns, this.maxColumns, types);
                this.columnTypeList.add(types);
            }
        }
        return (T)this;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public T setMaxColumns(int maxColumns) {
        for (ColumnType[] types : this.columnTypeList) {
            this._checkSizes(this.minColumns, maxColumns, types);
        }
        this.maxColumns = maxColumns;
        return (T)this;
    }

    public int getMinColumns() {
        return this.minColumns;
    }

    public T setMinColumns(int minColumns) {
        for (ColumnType[] types : this.columnTypeList) {
            this._checkSizes(minColumns, this.maxColumns, types);
        }
        this.minColumns = minColumns;
        return (T)this;
    }

    public boolean areExtraColumnsAllowed() {
        return this.extraColumnsAllowed;
    }

    public T setExtraColumnsAllowed(boolean extraColumnsAllowed) {
        this.extraColumnsAllowed = extraColumnsAllowed;
        return (T)this;
    }

    public ColumnType getExtraColumnsType() {
        return this.extraColumnsType;
    }

    public T setExtraColumnsType(ColumnType extraColumnsType) {
        this.extraColumnsType = extraColumnsType;
        return (T)this;
    }

    private void _checkSizes(int min, int max, ColumnType[] types) {
        if (min == 0) {
            throw new IllegalArgumentException("Minimum data set columns must be greater than or equal to 1. Actual=" + min);
        }
        if (max == 0) {
            throw new IllegalArgumentException("Maximum data set columns must be greater than or equal to 1. Actual=" + max);
        }
        if (min != -1 && max != -1 && min > max) {
            throw new IllegalArgumentException("Min=" + min + " data set columns cannot be greater than the max=" + max);
        }
        if (types != null) {
            if (min != -1 && types.length < min) {
                throw new IllegalArgumentException("columnTypes is smaller than " + min);
            }
            if (max != -1 && types.length > max) {
                throw new IllegalArgumentException("columnTypes is greater than " + max);
            }
        }
    }

    public ValidationError check(DataSet dataSet) {
        if (this.minColumns != -1 && dataSet.getColumns().size() < this.minColumns) {
            return this.createValidationError(101, new Object[0]);
        }
        if (this.maxColumns != -1 && dataSet.getColumns().size() > this.maxColumns) {
            return this.createValidationError(101, new Object[0]);
        }
        ValidationError error = null;
        boolean ok = false;
        int currentColumns = -1;
        for (ColumnType[] types : this.columnTypeList) {
            if (currentColumns < 0 || currentColumns < types.length) {
                currentColumns = types.length;
            }
            error = this.checkTypes(dataSet, types);
            if (ok || error != null) continue;
            ok = true;
        }
        if (!ok) {
            return error;
        }
        if (currentColumns > 0 && this.extraColumnsAllowed && this.extraColumnsType != null && dataSet.getColumns().size() > currentColumns) {
            for (int i = currentColumns; i < dataSet.getColumns().size(); ++i) {
                ColumnType columnType = dataSet.getColumnByIndex(i).getColumnType();
                if (columnType.equals((Object)this.extraColumnsType)) continue;
                return this.createValidationError(100, new Object[]{i, this.extraColumnsType, columnType});
            }
        }
        return null;
    }

    private ValidationError checkTypes(DataSet dataSet, ColumnType[] types) {
        for (int i = 0; i < dataSet.getColumns().size(); ++i) {
            ColumnType columnType = dataSet.getColumnByIndex(i).getColumnType();
            if (i >= types.length || columnType.equals((Object)types[i])) continue;
            return this.createValidationError(100, new Object[]{i, types[i], columnType});
        }
        return null;
    }

    protected ValidationError createValidationError(int error, Object ... params) {
        switch (error) {
            case 101: {
                return new ValidationError(error, "Number of columns exceeds the limits [" + (this.minColumns == -1 ? 0 : this.minColumns) + ", " + (this.maxColumns != -1 ? Integer.valueOf(this.maxColumns) : "unlimited") + "]");
            }
            case 100: {
                Integer idx = (Integer)params[0];
                ColumnType expected = (ColumnType)((Object)params[1]);
                ColumnType found = (ColumnType)((Object)params[2]);
                return new ValidationError(error, "Column " + idx + " type=" + (Object)((Object)found) + ", expected=" + (Object)((Object)expected));
            }
        }
        return new ValidationError(error);
    }
}

