/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.def;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.validation.groups.KafkaDataSetDefValidation;

public class KafkaDataSetDef
extends DataSetDef {
    @NotNull(groups={KafkaDataSetDefValidation.class})
    @Size(min=1, groups={KafkaDataSetDefValidation.class})
    protected @NotNull(groups={KafkaDataSetDefValidation.class}) @Size(min=1, groups={KafkaDataSetDefValidation.class}) String host = "localhost";
    @NotNull(groups={KafkaDataSetDefValidation.class})
    @Size(min=4, max=5, groups={KafkaDataSetDefValidation.class})
    @Digits(fraction=0, integer=5, message="Max number of digits is 5.", groups={KafkaDataSetDefValidation.class})
    protected @NotNull(groups={KafkaDataSetDefValidation.class}) @Size(min=4, max=5, groups={KafkaDataSetDefValidation.class}) @Digits(fraction=0, integer=5, message="Max number of digits is 5.", groups={KafkaDataSetDefValidation.class}) String port = "9999";
    protected MetricsTarget target = MetricsTarget.BROKER;
    protected String filter;
    protected String clientId;
    protected String nodeId;
    protected String topic;
    protected String partition;

    public KafkaDataSetDef() {
        super.setProvider(DataSetProviderType.KAFKA);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public MetricsTarget getTarget() {
        return this.target;
    }

    public void setTarget(MetricsTarget target) {
        this.target = target;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public DataSetDef clone() {
        KafkaDataSetDef def = new KafkaDataSetDef();
        this.clone(def);
        def.setHost(this.host);
        def.setPort(this.port);
        def.setTarget(this.target);
        def.setClientId(this.clientId);
        def.setFilter(this.filter);
        def.setNodeId(this.nodeId);
        def.setTopic(this.topic);
        def.setPartition(this.partition);
        return def;
    }

    public String toString() {
        return "KafkaDataSetDef [host=" + this.host + ", port=" + this.port + ", target=" + (Object)((Object)this.target) + ", filter=" + this.filter + ", clientId=" + this.clientId + ", nodeId=" + this.nodeId + ", topic=" + this.topic + ", partition=" + this.partition + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.partition == null ? 0 : this.partition.hashCode());
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaDataSetDef other = (KafkaDataSetDef)obj;
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        if (this.partition == null ? other.partition != null : !this.partition.equals(other.partition)) {
            return false;
        }
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        if (this.target != other.target) {
            return false;
        }
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }

    public static enum MetricsTarget {
        BROKER,
        PRODUCER,
        CONSUMER;

    }
}

