/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshallerExt;
import org.dashbuilder.json.JsonObject;

public class ELSDefJSONMarshaller
implements DataSetDefJSONMarshallerExt<ElasticSearchDataSetDef> {
    public static ELSDefJSONMarshaller INSTANCE = new ELSDefJSONMarshaller();
    public static final String SERVER_URL = "serverURL";
    public static final String CLUSTER_NAME = "clusterName";
    public static final String INDEX = "index";
    public static final String TYPE = "type";
    public static final String QUERY = "query";
    public static final String RELEVANCE = "relevance";
    public static final String CACHE_SYNCED = "cacheSynced";

    @Override
    public void fromJson(ElasticSearchDataSetDef dataSetDef, JsonObject json) {
        String serverURL = json.getString(SERVER_URL);
        String clusterName = json.getString(CLUSTER_NAME);
        String index = json.getString(INDEX);
        String type = json.getString(TYPE);
        String query = json.getString(QUERY);
        String relevance = json.getString(RELEVANCE);
        String cacheEnabled = json.getString("cacheEnabled");
        String cacheMaxRows = json.getString("cacheMaxRows");
        String cacheSynced = json.getString(CACHE_SYNCED);
        if (DataSetDefJSONMarshaller.isBlank(serverURL)) {
            throw new IllegalArgumentException("The serverURL property is missing.");
        }
        dataSetDef.setServerURL(serverURL);
        if (DataSetDefJSONMarshaller.isBlank(clusterName)) {
            throw new IllegalArgumentException("The clusterName property is missing.");
        }
        dataSetDef.setClusterName(clusterName);
        if (DataSetDefJSONMarshaller.isBlank(index)) {
            throw new IllegalArgumentException("The index property is missing.");
        }
        dataSetDef.setIndex(index);
        if (!DataSetDefJSONMarshaller.isBlank(type)) {
            dataSetDef.setType(type);
        }
        if (!DataSetDefJSONMarshaller.isBlank(query)) {
            dataSetDef.setQuery(query);
        }
        if (!DataSetDefJSONMarshaller.isBlank(relevance)) {
            dataSetDef.setRelevance(relevance);
        }
        if (!DataSetDefJSONMarshaller.isBlank(cacheEnabled)) {
            dataSetDef.setCacheEnabled(Boolean.parseBoolean(cacheEnabled));
        }
        if (!DataSetDefJSONMarshaller.isBlank(cacheMaxRows)) {
            dataSetDef.setCacheMaxRows(Integer.parseInt(cacheMaxRows));
        }
    }

    @Override
    public void toJson(ElasticSearchDataSetDef dataSetDef, JsonObject json) {
        json.put(SERVER_URL, dataSetDef.getServerURL());
        json.put(CLUSTER_NAME, dataSetDef.getClusterName());
        json.put(INDEX, dataSetDef.getIndex());
        json.put(TYPE, dataSetDef.getType());
        json.put("allColumns", dataSetDef.isAllColumnsEnabled());
    }
}

