/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.function;

import java.util.HashSet;
import java.util.List;
import org.dashbuilder.dataset.engine.function.AbstractFunction;
import org.dashbuilder.dataset.group.AggregateFunctionType;

public class DistinctFunction
extends AbstractFunction {
    public AggregateFunctionType getType() {
        return AggregateFunctionType.DISTINCT;
    }

    public Object aggregate(List values) {
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        HashSet distincts = new HashSet();
        for (Object o : values) {
            if (distincts.contains(o)) continue;
            distincts.add(o);
        }
        return (double)distincts.size();
    }

    public Object aggregate(List values, List<Integer> rows) {
        if (rows == null) {
            return this.aggregate(values);
        }
        if (rows.isEmpty()) {
            return 0.0;
        }
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        HashSet distincts = new HashSet();
        for (Integer row : rows) {
            Object o = values.get(row);
            if (distincts.contains(o)) continue;
            distincts.add(o);
        }
        return (double)distincts.size();
    }
}

