/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.group;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.Interval;

public class IntervalListMonth
extends IntervalList {
    protected Map<Integer, Interval> intervalMap = new HashMap<Integer, Interval>();

    public IntervalListMonth(ColumnGroup columnGroup) {
        super(columnGroup);
        Month firstMonth = columnGroup.getFirstMonthOfYear();
        int monthIndex = firstMonth.getIndex();
        Month[] months = Month.getAll();
        for (int i = 0; i < months.length; ++i) {
            Month month = months[monthIndex - 1];
            Interval interval = new Interval(Integer.toString(month.getIndex()), i);
            interval.setType(columnGroup.getIntervalSize());
            this.add(interval);
            this.intervalMap.put(monthIndex - 1, interval);
            monthIndex = Month.nextIndex((int)monthIndex);
        }
    }

    @Override
    public Interval locateInterval(Object value) {
        Date d = (Date)value;
        return this.intervalMap.get(d.getMonth());
    }
}

