/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.engine.Chronometer;
import org.dashbuilder.dataset.engine.SharedDataSetOpEngine;
import org.dashbuilder.dataset.engine.filter.DataSetFilterAlgorithm;
import org.dashbuilder.dataset.engine.filter.DefaultFilterAlgorithm;
import org.dashbuilder.dataset.engine.function.AggregateFunctionManagerImpl;
import org.dashbuilder.dataset.engine.group.IntervalBuilderDynamicLabel;
import org.dashbuilder.dataset.engine.group.IntervalBuilderFixedDate;
import org.dashbuilder.dataset.engine.group.IntervalBuilderLocator;
import org.dashbuilder.dataset.engine.index.TransientDataSetIndexRegistry;
import org.dashbuilder.dataset.engine.index.spi.DataSetIndexRegistry;
import org.dashbuilder.dataset.engine.sort.CollectionsDataSetSort;
import org.dashbuilder.dataset.engine.sort.DataSetSortAlgorithm;
import org.dashbuilder.dataset.group.AggregateFunctionManager;
import org.dashbuilder.dataset.uuid.UUIDGenerator;

public abstract class AbstractDataSetCore {
    private DataSetManager dataSetManager;
    private SharedDataSetOpEngine sharedDataSetOpEngine;
    private IntervalBuilderLocator intervalBuilderLocator;
    private Chronometer chronometer;
    private UUIDGenerator uuidGenerator;
    private AggregateFunctionManager aggregateFunctionManager;
    private DataSetIndexRegistry indexRegistry;
    private DataSetSortAlgorithm sortAlgorithm;
    private DataSetFilterAlgorithm filterAlgorithm;
    private IntervalBuilderDynamicLabel intervalBuilderDynamicLabel;
    private IntervalBuilderFixedDate intervalBuilderFixedDate;

    protected <T> T checkNotNull(T obj, String name) {
        if (obj == null) {
            throw new IllegalStateException(name + " is null.");
        }
        return obj;
    }

    public DataSetManager getDataSetManager() {
        if (this.dataSetManager == null) {
            this.dataSetManager = this.newDataSetManager();
        }
        return this.dataSetManager;
    }

    public SharedDataSetOpEngine getSharedDataSetOpEngine() {
        if (this.sharedDataSetOpEngine == null) {
            this.sharedDataSetOpEngine = this.newSharedDataSetOpEngine();
        }
        return this.sharedDataSetOpEngine;
    }

    public AggregateFunctionManager getAggregateFunctionManager() {
        if (this.aggregateFunctionManager == null) {
            this.aggregateFunctionManager = this.newAggregateFunctionManager();
        }
        return this.aggregateFunctionManager;
    }

    public DataSetIndexRegistry getIndexRegistry() {
        if (this.indexRegistry == null) {
            this.indexRegistry = this.newIndexRegistry();
        }
        return this.indexRegistry;
    }

    public DataSetSortAlgorithm getSortAlgorithm() {
        if (this.sortAlgorithm == null) {
            this.sortAlgorithm = this.newSortAlgorithm();
        }
        return this.sortAlgorithm;
    }

    public DataSetFilterAlgorithm getFilterAlgorithm() {
        if (this.filterAlgorithm == null) {
            this.filterAlgorithm = this.newFilterAlgorithm();
        }
        return this.filterAlgorithm;
    }

    public IntervalBuilderLocator getIntervalBuilderLocator() {
        if (this.intervalBuilderLocator == null) {
            this.intervalBuilderLocator = this.newIntervalBuilderLocator();
        }
        return this.intervalBuilderLocator;
    }

    public IntervalBuilderDynamicLabel getIntervalBuilderDynamicLabel() {
        if (this.intervalBuilderDynamicLabel == null) {
            this.intervalBuilderDynamicLabel = this.newIntervalBuilderDynamicLabel();
        }
        return this.intervalBuilderDynamicLabel;
    }

    public IntervalBuilderFixedDate getIntervalBuilderFixedDate() {
        if (this.intervalBuilderFixedDate == null) {
            this.intervalBuilderFixedDate = this.newIntervalBuilderFixedDate();
        }
        return this.intervalBuilderFixedDate;
    }

    public Chronometer getChronometer() {
        if (this.chronometer == null) {
            this.chronometer = this.newChronometer();
        }
        return this.chronometer;
    }

    public UUIDGenerator getUuidGenerator() {
        if (this.uuidGenerator == null) {
            this.uuidGenerator = this.newUuidGenerator();
        }
        return this.uuidGenerator;
    }

    public void setDataSetManager(DataSetManager dataSetManager) {
        this.dataSetManager = dataSetManager;
    }

    public void setAggregateFunctionManager(AggregateFunctionManager aggregateFunctionManager) {
        this.aggregateFunctionManager = aggregateFunctionManager;
    }

    public void setIndexRegistry(DataSetIndexRegistry indexRegistry) {
        this.indexRegistry = indexRegistry;
    }

    public void setSortAlgorithm(DataSetSortAlgorithm sortAlgorithm) {
        this.sortAlgorithm = sortAlgorithm;
    }

    public void setFilterAlgorithm(DataSetFilterAlgorithm filterAlgorithm) {
        this.filterAlgorithm = filterAlgorithm;
    }

    public void setIntervalBuilderLocator(IntervalBuilderLocator intervalBuilderLocator) {
        this.intervalBuilderLocator = intervalBuilderLocator;
    }

    public void setIntervalBuilderDynamicLabel(IntervalBuilderDynamicLabel intervalBuilderDynamicLabel) {
        this.intervalBuilderDynamicLabel = intervalBuilderDynamicLabel;
    }

    public void setIntervalBuilderFixedDate(IntervalBuilderFixedDate intervalBuilderFixedDate) {
        this.intervalBuilderFixedDate = intervalBuilderFixedDate;
    }

    public void setChronometer(Chronometer chronometer) {
        this.chronometer = chronometer;
    }

    public void setUuidGenerator(UUIDGenerator uuidGenerator) {
        this.uuidGenerator = uuidGenerator;
    }

    protected SharedDataSetOpEngine newSharedDataSetOpEngine() {
        return new SharedDataSetOpEngine(this.checkNotNull(this.getAggregateFunctionManager(), "AggregateFunctionManager"), this.checkNotNull(this.getIntervalBuilderLocator(), "IntervalBuilderLocator"), this.checkNotNull(this.getIndexRegistry(), "DataSetIndexRegistry"), this.checkNotNull(this.getSortAlgorithm(), "DataSetSortAlgorithm"), this.checkNotNull(this.getFilterAlgorithm(), "DataSetFilterAlgorithm"), this.checkNotNull(this.getChronometer(), "Chronometer"));
    }

    protected AggregateFunctionManager newAggregateFunctionManager() {
        return new AggregateFunctionManagerImpl();
    }

    protected DataSetIndexRegistry newIndexRegistry() {
        return new TransientDataSetIndexRegistry(this.checkNotNull(this.getUuidGenerator(), "UUIDGenerator"));
    }

    protected DataSetSortAlgorithm newSortAlgorithm() {
        return new CollectionsDataSetSort();
    }

    protected DataSetFilterAlgorithm newFilterAlgorithm() {
        return new DefaultFilterAlgorithm();
    }

    protected IntervalBuilderDynamicLabel newIntervalBuilderDynamicLabel() {
        return new IntervalBuilderDynamicLabel();
    }

    protected IntervalBuilderFixedDate newIntervalBuilderFixedDate() {
        return new IntervalBuilderFixedDate();
    }

    protected abstract DataSetManager newDataSetManager();

    protected abstract IntervalBuilderLocator newIntervalBuilderLocator();

    protected abstract Chronometer newChronometer();

    protected abstract UUIDGenerator newUuidGenerator();
}

