/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.SQLStatement;

public class CreateTable
extends SQLStatement<CreateTable> {
    protected List<Column> columns = new ArrayList<Column>();
    protected List<Column> primaryKeys = new ArrayList<Column>();

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Column> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public CreateTable(Connection connection, Dialect dialect) {
        super(connection, dialect);
    }

    public CreateTable columns(Column ... cols) {
        for (Column column : cols) {
            this.columns.add(this.fix(column));
        }
        return this;
    }

    public CreateTable primaryKey(Column ... cols) {
        for (Column column : cols) {
            this.primaryKeys.add(this.fix(column));
        }
        return this;
    }

    public String getSQL() {
        this.fixColumns();
        return this.dialect.getSQL(this);
    }

    public String toString() {
        return this.getSQL();
    }

    public void execute() throws SQLException {
        String sql = this.getSQL();
        JDBCUtils.execute(this.connection, sql);
    }
}

