/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.integration;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelReader;
import org.appformer.maven.integration.ArtifactResolver;
import org.appformer.maven.integration.DependencyDescriptor;
import org.appformer.maven.integration.PomParser;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.AFReleaseIdImpl;
import org.appformer.maven.support.DependencyFilter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilesArtifactResolver
extends ArtifactResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractFilesArtifactResolver.class);
    private ClassLoader classLoader;
    private List<URL> jarRepository;
    private List<URL> effectivePoms;
    private PomParser pomParser;

    AbstractFilesArtifactResolver(ClassLoader classLoader, AFReleaseId releaseId) {
        this.classLoader = classLoader;
        this.jarRepository = new ArrayList<URL>();
        this.effectivePoms = new ArrayList<URL>();
        this.init(releaseId);
    }

    public boolean isLoaded() {
        return this.pomParser != null;
    }

    private void init(AFReleaseId releaseId) {
        this.jarRepository = this.buildResources(name -> this.isInJarStructuredFolder((String)name, "jar"));
        this.effectivePoms = this.buildResources(name -> this.isInJarStructuredFolder((String)name, "pom"));
        this.pomParser = this.buildPomParser(releaseId);
    }

    protected abstract List<URL> buildResources(Predicate<String> var1);

    protected abstract URL getURL(String var1);

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<URL> getJarRepository() {
        return this.jarRepository;
    }

    public PomParser getPomParser() {
        return this.pomParser;
    }

    public List<URL> getEffectivePoms() {
        return this.effectivePoms;
    }

    private boolean isInJarStructuredFolder(String name, String type) {
        String[] paths;
        for (String path : paths = new String[]{"BOOT-INF/classes/KIE-INF/", "KIE-INF/lib/"}) {
            if (!name.contains(path) || !name.endsWith("." + type)) continue;
            return true;
        }
        return false;
    }

    private PomParser buildPomParser(AFReleaseId releaseId) {
        PomParser pomParser;
        block10: {
            List url = this.effectivePoms.stream().filter(e -> e.getFile().endsWith(this.toFile(releaseId, "pom"))).collect(Collectors.toList());
            if (url.isEmpty()) {
                return null;
            }
            String path = ((URL)url.get(0)).toExternalForm();
            URL pomFile = this.getURL(path);
            if (pomFile == null) {
                log.warn("Maven pom not found in path {}", (Object)path);
                return null;
            }
            InputStream pomStream = pomFile.openStream();
            try {
                DefaultModelReader reader = new DefaultModelReader();
                Model model = reader.read(pomStream, Collections.emptyMap());
                pomParser = filter -> {
                    ArrayList<DependencyDescriptor> deps = new ArrayList<DependencyDescriptor>();
                    for (Dependency dep : model.getDependencies()) {
                        DependencyDescriptor depDescr = new DependencyDescriptor(dep);
                        if (!depDescr.isValid() || !filter.accept(depDescr.getReleaseId(), depDescr.getScope())) continue;
                        deps.add(depDescr);
                    }
                    return deps;
                };
                if (pomStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (pomStream != null) {
                        try {
                            pomStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    log.error("Could not read pom in jar {}", (Object)pomFile);
                    return null;
                }
            }
            pomStream.close();
        }
        return pomParser;
    }

    @Override
    public ArtifactResolver.ArtifactLocation resolveArtifactLocation(AFReleaseId releaseId) {
        log.debug("resolve location {}", (Object)releaseId);
        Optional<URL> url = this.tryInStructuredJar(releaseId);
        if (url.isPresent()) {
            DefaultArtifact artifact = new DefaultArtifact(releaseId.toExternalForm());
            return new ArtifactResolver.ArtifactLocation(artifact.setFile(new File(url.get().toString())), url.get(), true);
        }
        return null;
    }

    @Override
    public Artifact resolveArtifact(AFReleaseId releaseId) {
        Optional<URL> url = this.tryInStructuredJar(releaseId);
        if (url.isPresent()) {
            log.info("Resolved in jar repository {}", url);
            DefaultArtifact artifact = new DefaultArtifact(releaseId.toExternalForm());
            return artifact.setFile(new File(url.get().toString()));
        }
        return null;
    }

    protected Optional<URL> tryInStructuredJar(String artifactName) {
        for (URL inJarURL : this.jarRepository) {
            if (!inJarURL.getFile().endsWith(artifactName)) continue;
            return Optional.of(inJarURL);
        }
        return Optional.empty();
    }

    protected Optional<URL> tryInStructuredJar(AFReleaseId releaseId) {
        return this.tryInStructuredJar(this.toFile(releaseId, "jar"));
    }

    private String toFile(AFReleaseId releaseId, String type) {
        return releaseId.getArtifactId() + "-" + releaseId.getVersion() + "." + type;
    }

    @Override
    public List<DependencyDescriptor> getArtifactDependecies(String artifactName) {
        AFReleaseIdImpl releaseId = new AFReleaseIdImpl(artifactName);
        PomParser builtPomParser = this.buildPomParser((AFReleaseId)releaseId);
        return builtPomParser != null ? builtPomParser.getPomDirectDependencies(DependencyFilter.COMPILE_FILTER) : Collections.emptyList();
    }

    @Override
    public List<DependencyDescriptor> getPomDirectDependencies(DependencyFilter dependencyFilter) {
        return this.pomParser != null ? this.pomParser.getPomDirectDependencies(dependencyFilter) : Collections.emptyList();
    }
}

