/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.uberfire.social.activities.model.DefaultTypes;
import org.kie.uberfire.social.activities.model.SocialEventType;
import org.kie.uberfire.social.activities.service.SocialAdapter;
import org.kie.uberfire.social.activities.service.SocialAdapterRepositoryAPI;
import org.kie.uberfire.social.activities.service.SocialEventTypeRepositoryAPI;
import org.kie.uberfire.social.activities.service.SocialUserPersistenceAPI;

@Service
@ApplicationScoped
public class SocialEventTypeRepository
implements SocialEventTypeRepositoryAPI {
    @Inject
    SocialAdapterRepositoryAPI socialAdapterRepository;
    @Inject
    @Named(value="socialUserPersistenceAPI")
    SocialUserPersistenceAPI socialUserPersistence;
    private List<String> eventTypesNames;
    private List<SocialEventType> eventTypes;

    @PostConstruct
    public void setup() {
        Map<Class, SocialAdapter> socialAdapters = this.getSocialAdapters();
        this.eventTypesNames = new ArrayList<String>();
        this.eventTypes = new ArrayList<SocialEventType>();
        for (SocialAdapter socialAdapter : socialAdapters.values()) {
            this.eventTypesNames.add(socialAdapter.socialEventType().name());
            this.eventTypes.add(socialAdapter.socialEventType());
        }
        this.eventTypes.add((SocialEventType)DefaultTypes.DUMMY_EVENT);
    }

    Map<Class, SocialAdapter> getSocialAdapters() {
        return this.socialAdapterRepository.getSocialAdapters();
    }

    public List<SocialEventType> findAll() {
        return this.eventTypes;
    }

    public SocialEventType findType(String typeName) {
        for (SocialEventType type : this.eventTypes) {
            if (!type.name().equalsIgnoreCase(typeName)) continue;
            return type;
        }
        throw new TypeNotFoundException();
    }

    private class TypeNotFoundException
    extends RuntimeException {
        private TypeNotFoundException() {
        }
    }
}

