/*
 * Decompiled with CFR 0.152.
 */
package org.kie.uberfire.social.activities.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.uberfire.social.activities.model.SocialUser;
import org.kie.uberfire.social.activities.service.SocialUserPersistenceAPI;
import org.kie.uberfire.social.activities.service.SocialUserServiceAPI;

@Service
@ApplicationScoped
public class SocialUserService
implements SocialUserServiceAPI {
    @Inject
    @Named(value="socialUserPersistenceAPI")
    private SocialUserPersistenceAPI socialUserPersistenceAPI;

    public void userFollowAnotherUser(String followerUsername, String followUsername) {
        SocialUser follower = this.socialUserPersistenceAPI.getSocialUser(followerUsername);
        SocialUser follow = this.socialUserPersistenceAPI.getSocialUser(followUsername);
        follower.follow(follow);
        this.socialUserPersistenceAPI.updateUsers(new SocialUser[]{follower, follow});
    }

    public void userUnfollowAnotherUser(String followerUsername, String followUsername) {
        SocialUser follower = this.socialUserPersistenceAPI.getSocialUser(followerUsername);
        SocialUser user = this.socialUserPersistenceAPI.getSocialUser(followUsername);
        follower.unfollow(user);
        this.socialUserPersistenceAPI.updateUsers(new SocialUser[]{follower, user});
    }

    public void update(SocialUser ... users) {
        this.socialUserPersistenceAPI.updateUsers(users);
    }
}

