/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.docker.config.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.guvnor.ala.config.CloneableConfig;
import org.guvnor.ala.docker.config.DockerRuntimeConfig;
import org.guvnor.ala.docker.config.DockerRuntimeExecConfig;
import org.guvnor.ala.pipeline.ContextAware;
import org.guvnor.ala.runtime.providers.ProviderId;

public class ContextAwareDockerRuntimeExecConfig
implements ContextAware,
DockerRuntimeExecConfig,
CloneableConfig<DockerRuntimeExecConfig> {
    @JsonIgnore
    private Map<String, ?> context;
    private ProviderId providerId;
    private String image;
    private String port;
    private boolean pull;

    public ContextAwareDockerRuntimeExecConfig() {
    }

    public ContextAwareDockerRuntimeExecConfig(ProviderId providerId, String image, String port, boolean pull) {
        this.providerId = providerId;
        this.image = image;
        this.port = port;
        this.pull = pull;
    }

    @JsonIgnore
    public void setContext(Map<String, ?> context) {
        this.context = context;
        DockerRuntimeConfig dockerRuntimeConfiguration = (DockerRuntimeConfig)context.get("docker-runtime-config");
        this.providerId = dockerRuntimeConfiguration.getProviderId();
        this.image = dockerRuntimeConfiguration.getImage();
        this.port = dockerRuntimeConfiguration.getPort();
        this.pull = dockerRuntimeConfiguration.isPull();
    }

    public ProviderId getProviderId() {
        return this.providerId;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public boolean isPull() {
        return this.pull;
    }

    public void setProviderId(ProviderId providerId) {
        this.providerId = providerId;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setPull(boolean pull) {
        this.pull = pull;
    }

    public String toString() {
        return "ContextAwareDockerRuntimeExecConfig{providerId=" + this.providerId + ", image=" + this.image + ", port=" + this.port + ", pull=" + this.pull + '}';
    }

    public DockerRuntimeExecConfig asNewClone(DockerRuntimeExecConfig source) {
        return new ContextAwareDockerRuntimeExecConfig(source.getProviderId(), source.getImage(), source.getPort(), source.isPull());
    }
}

