/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.docker.executor;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import org.guvnor.ala.build.maven.model.MavenBuild;
import org.guvnor.ala.config.BuildConfig;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.docker.config.DockerBuildConfig;
import org.guvnor.ala.docker.model.DockerBuildImpl;
import org.guvnor.ala.pipeline.BiFunctionConfigExecutor;

public class DockerBuildConfigExecutor
implements BiFunctionConfigExecutor<MavenBuild, DockerBuildConfig, BuildConfig> {
    public Optional<BuildConfig> apply(MavenBuild buildConfig, DockerBuildConfig dockerBuildConfig) {
        ArrayList<String> goals = new ArrayList<String>(buildConfig.getGoals());
        Properties properties = new Properties(buildConfig.getProperties());
        if (dockerBuildConfig.push()) {
            properties.put("docker.username", dockerBuildConfig.getUsername());
            properties.put("docker.password", dockerBuildConfig.getPassword());
        }
        goals.add("docker:build");
        if (dockerBuildConfig.push()) {
            goals.add("docker:push");
        }
        return Optional.of(new DockerBuildImpl(buildConfig.getProject(), goals, properties));
    }

    public Class<? extends Config> executeFor() {
        return DockerBuildConfig.class;
    }

    public String outputId() {
        return "maven-config";
    }

    public String inputId() {
        return "maven-config";
    }
}

