/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.internal;

import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.ala.openshift.jackson.core.JsonParser;
import org.kie.workbench.ala.openshift.jackson.core.JsonProcessingException;
import org.kie.workbench.ala.openshift.jackson.databind.DeserializationContext;
import org.kie.workbench.ala.openshift.jackson.databind.JsonDeserializer;
import org.kie.workbench.ala.openshift.jackson.databind.JsonNode;
import org.kie.workbench.ala.openshift.jackson.databind.node.ObjectNode;

public class KubernetesDeserializer
extends JsonDeserializer<KubernetesResource> {
    private static final String KIND = "kind";
    private static final String KUBERNETES_PACKAGE_PREFIX = "io.fabric8.kubernetes.api.model.";
    private static final String KUBERNETES_EXTENSIONS_PACKAGE_PREFIX = "io.fabric8.kubernetes.api.model.extensions.";
    private static final String KUBERNETES_APIEXTENSIONS_PACKAGE_PREFIX = "io.fabric8.kubernetes.api.model.apiextensions.";
    private static final String OPENSHIFT_PACKAGE_PREFIX = "io.fabric8.openshift.api.model.";
    private static final Map<String, Class<? extends KubernetesResource>> MAP = new HashMap<String, Class<? extends KubernetesResource>>();

    @Override
    public KubernetesResource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = (ObjectNode)jp.readValueAsTree();
        JsonNode kind = node.get(KIND);
        if (kind != null) {
            String value = kind.textValue();
            Class resourceType = KubernetesDeserializer.getTypeForName(value);
            if (resourceType == null) {
                throw ctxt.mappingException("No resource type found for kind:" + value);
            }
            return (KubernetesResource)jp.getCodec().treeToValue(node, resourceType);
        }
        return null;
    }

    private static Class getTypeForName(String name) {
        Class result = MAP.get(name);
        if (result == null && (result = KubernetesDeserializer.loadClassIfExists(KUBERNETES_PACKAGE_PREFIX + name)) == null && (result = KubernetesDeserializer.loadClassIfExists(KUBERNETES_EXTENSIONS_PACKAGE_PREFIX + name)) == null && (result = KubernetesDeserializer.loadClassIfExists(OPENSHIFT_PACKAGE_PREFIX + name)) == null) {
            result = KubernetesDeserializer.loadClassIfExists(KUBERNETES_APIEXTENSIONS_PACKAGE_PREFIX + name);
        }
        if (result != null) {
            MAP.put(name, result);
        }
        return result;
    }

    private static Class loadClassIfExists(String className) {
        try {
            return KubernetesDeserializer.class.getClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        MAP.put("List", KubernetesList.class);
    }
}

