/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.openshift.config;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.guvnor.ala.openshift.config.OpenShiftRuntimeConfig;

@JsonIgnoreType
public class OpenShiftParameters
extends LinkedHashMap<String, String>
implements Map<String, String> {
    public static final String DEFAULT_PARAM_DELIMITER = ",";
    public static final String DEFAULT_PARAM_ASSIGNER = "=";
    private final String paramDelimiter;
    private final String paramAssigner;

    public OpenShiftParameters() {
        this(DEFAULT_PARAM_DELIMITER);
    }

    public OpenShiftParameters(String paramDelimiter) {
        this(paramDelimiter, DEFAULT_PARAM_ASSIGNER);
    }

    public OpenShiftParameters(String paramDelimiter, String paramAssigner) {
        this.paramDelimiter = paramDelimiter;
        this.paramAssigner = paramAssigner;
    }

    public String getParamDelimiter() {
        return this.paramDelimiter;
    }

    public String getParamAssigner() {
        return this.paramAssigner;
    }

    public OpenShiftParameters param(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException(String.format("param key [%s] and/or value [%s] is null", key, value));
        }
        this.put(key, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            sb.append((String)entry.getKey());
            sb.append(this.paramAssigner);
            sb.append((String)entry.getValue());
            if (!iter.hasNext()) continue;
            sb.append(this.paramDelimiter);
        }
        return sb.toString();
    }

    public static OpenShiftParameters fromString(String str) {
        return OpenShiftParameters.fromString(str, DEFAULT_PARAM_DELIMITER);
    }

    public static OpenShiftParameters fromString(String str, String paramDelimiter) {
        return OpenShiftParameters.fromString(str, paramDelimiter, DEFAULT_PARAM_ASSIGNER);
    }

    public static OpenShiftParameters fromString(String str, String paramDelimiter, String paramAssigner) {
        OpenShiftParameters params = new OpenShiftParameters(paramDelimiter, paramAssigner);
        if (str != null) {
            String[] splitAll = str.split(paramDelimiter);
            for (int i = 0; i < splitAll.length; ++i) {
                String key;
                int pos = splitAll[i].indexOf(paramAssigner);
                if (pos <= 0 || (key = splitAll[i].substring(0, pos).trim()).isEmpty()) continue;
                String value = splitAll[i].substring(pos + 1, splitAll[i].length());
                params.put(key, value);
            }
        }
        return params;
    }

    public static OpenShiftParameters fromRuntimeConfig(OpenShiftRuntimeConfig runtimeConfig) {
        String paramVals;
        String paramAssign;
        String paramDelim = runtimeConfig.getResourceTemplateParamDelimiter();
        if (paramDelim == null || paramDelim.isEmpty()) {
            paramDelim = DEFAULT_PARAM_DELIMITER;
        }
        if ((paramAssign = runtimeConfig.getResourceTemplateParamAssigner()) == null || paramAssign.isEmpty()) {
            paramAssign = DEFAULT_PARAM_ASSIGNER;
        }
        if ((paramVals = runtimeConfig.getResourceTemplateParamValues()) != null) {
            return OpenShiftParameters.fromString(paramVals, paramDelim, paramAssign);
        }
        return new OpenShiftParameters(paramDelim, paramAssign);
    }
}

