/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.vfs;

import java.util.ArrayList;
import java.util.Arrays;
import javax.enterprise.inject.Instance;
import org.guvnor.ala.marshalling.BaseMarshallerRegistryTest;
import org.guvnor.ala.marshalling.Marshaller;
import org.guvnor.ala.registry.vfs.VFSMarshallerRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class VFSMarshallerRegistryTest
extends BaseMarshallerRegistryTest {
    @Mock
    private Instance<Marshaller<?>> marshallerInstance;
    private Class[] marshallerClasses = new Class[]{String.class, Boolean.class, Integer.class, Long.class, Float.class, Double.class};

    @Before
    public void setUp() {
        super.setUp();
        ArrayList marshallers = new ArrayList();
        Mockito.when((Object)this.marshallerInstance.iterator()).thenReturn(marshallers.iterator());
        this.marshallerRegistry = new VFSMarshallerRegistry(this.marshallerInstance);
        ((VFSMarshallerRegistry)this.marshallerRegistry).init();
    }

    @Test
    public void testInit() {
        ArrayList marshallers = new ArrayList();
        Arrays.stream(this.marshallerClasses).forEach(clazz -> {
            Marshaller marshaller = (Marshaller)Mockito.mock(Marshaller.class);
            Mockito.when((Object)marshaller.getType()).thenReturn(clazz);
            marshallers.add(marshaller);
        });
        Mockito.when((Object)this.marshallerInstance.iterator()).thenReturn(marshallers.iterator());
        ((VFSMarshallerRegistry)this.marshallerRegistry).init();
        for (int i = 0; i < this.marshallerClasses.length; ++i) {
            Class clazz2 = this.marshallerClasses[i];
            Marshaller marshaller = this.marshallerRegistry.get(clazz2);
            Assert.assertNotNull((Object)marshaller);
            Assert.assertEquals((Object)clazz2, (Object)marshaller.getType());
        }
    }
}

