/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.vfs;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.marshalling.Marshaller;
import org.guvnor.ala.registry.vfs.VFSMarshallerRegistry;
import org.guvnor.ala.registry.vfs.VFSRegistryEntry;
import org.guvnor.ala.registry.vfs.VFSRegistryEntryMarshaller;
import org.guvnor.ala.registry.vfs.VFSRegistryHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class VFSRegistryHelperTest {
    private static final String DIRECTORY_NAME = "DIRECTORY_NAME";
    private static final String MARSHALLED_VALUE = "MARSHALLED_VALUE";
    private static final String MARSHALLED_ENTRY = "MARSHALLED_ENTRY";
    private static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    private static final int ENTRY_COUNT = 10;
    @Mock
    private VFSMarshallerRegistry marshallerRegistry;
    @Mock
    private IOService ioService;
    @Mock
    private FileSystem fileSystem;
    private VFSRegistryHelper registryHelper;
    @Mock
    private Path provisioningPath;
    @Mock
    private VFSRegistryEntryMarshaller entryMarshaller;
    @Mock
    private Path path;
    @Mock
    private Marshaller marshaller;
    @Mock
    private Object value;
    @Mock
    private VFSRegistryEntry entry;
    @Mock
    private Path rootPath;
    private List<Path> entryPaths;
    private List<Object> expectedObjects;
    private List<VFSRegistryEntry> entries;
    @Mock
    private DirectoryStream.Filter<Path> filter;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        Mockito.when((Object)this.fileSystem.getPath("master", new String[]{"provisioning"})).thenReturn((Object)this.provisioningPath);
        Mockito.when((Object)this.marshallerRegistry.get(VFSRegistryEntry.class)).thenReturn((Object)this.entryMarshaller);
        this.registryHelper = (VFSRegistryHelper)Mockito.spy((Object)new VFSRegistryHelper(this.marshallerRegistry, this.ioService, this.fileSystem));
        this.registryHelper.init();
        ((FileSystem)Mockito.verify((Object)this.fileSystem, (VerificationMode)Mockito.times((int)1))).getPath("master", new String[]{"provisioning"});
    }

    @Test
    public void testEnsureDirectoryWhenDirectoryExists() {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.provisioningPath.resolve(DIRECTORY_NAME)).thenReturn((Object)path);
        Mockito.when((Object)this.ioService.exists(path)).thenReturn((Object)true);
        Path result = this.registryHelper.ensureDirectory(DIRECTORY_NAME);
        ((Path)Mockito.verify((Object)this.provisioningPath, (VerificationMode)Mockito.times((int)1))).resolve(DIRECTORY_NAME);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).createDirectory(path, new FileAttribute[0]);
        Assert.assertEquals((Object)path, (Object)result);
    }

    @Test
    public void testEnsureDirectoryWhenDirectoryNotExists() {
        Path path = (Path)Mockito.mock(Path.class);
        Path createdPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.provisioningPath.resolve(DIRECTORY_NAME)).thenReturn((Object)path);
        Mockito.when((Object)this.ioService.exists(path)).thenReturn((Object)false);
        Mockito.when((Object)this.ioService.createDirectory(path, new FileAttribute[0])).thenReturn((Object)createdPath);
        Path result = this.registryHelper.ensureDirectory(DIRECTORY_NAME);
        ((Path)Mockito.verify((Object)this.provisioningPath, (VerificationMode)Mockito.times((int)1))).resolve(DIRECTORY_NAME);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).createDirectory(path, new FileAttribute[0]);
        Assert.assertEquals((Object)createdPath, (Object)result);
    }

    @Test
    public void testMd5Hex() {
        String result = this.registryHelper.md5Hex(null);
        Assert.assertEquals((Object)"", (Object)result);
        result = this.registryHelper.md5Hex(DIRECTORY_NAME);
        Assert.assertEquals((Object)DigestUtils.md5Hex((String)DIRECTORY_NAME), (Object)result);
    }

    @Test
    public void testStoreEntryWhenMarshallerNotExists() throws Exception {
        Object value = Mockito.mock(Object.class);
        Mockito.when((Object)this.marshallerRegistry.get(value.getClass())).thenReturn(null);
        this.expectedException.expectMessage("No marshaller was found for class: " + value.getClass());
        this.registryHelper.storeEntry((Path)Mockito.mock(Path.class), value);
    }

    @Test
    public void testStoreEntryWhenMarshallerExists() throws Exception {
        Mockito.when((Object)this.marshallerRegistry.get(this.value.getClass())).thenReturn((Object)this.marshaller);
        Mockito.when((Object)this.marshaller.marshal(this.value)).thenReturn((Object)MARSHALLED_VALUE);
        VFSRegistryEntry expectedEntry = new VFSRegistryEntry(this.value.getClass().getName(), MARSHALLED_VALUE);
        Mockito.when((Object)this.entryMarshaller.marshal((Object)expectedEntry)).thenReturn((Object)MARSHALLED_ENTRY);
        this.registryHelper.storeEntry(this.path, this.value);
        ((VFSMarshallerRegistry)Mockito.verify((Object)this.marshallerRegistry, (VerificationMode)Mockito.times((int)1))).get(this.value.getClass());
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1))).writeBatch(this.path, MARSHALLED_ENTRY);
    }

    @Test
    public void testReadEntryWhenMarshallerNotExists() throws Exception {
        Mockito.when((Object)this.ioService.readAllString(this.path)).thenReturn((Object)MARSHALLED_ENTRY);
        Mockito.when((Object)this.entryMarshaller.unmarshal(MARSHALLED_ENTRY)).thenReturn((Object)this.entry);
        Mockito.when((Object)this.entry.getContentType()).thenReturn((Object)Object.class.getName());
        Mockito.when((Object)this.marshallerRegistry.get(Object.class.getClass())).thenReturn(null);
        this.expectedException.expectMessage("No marshaller was found for class: " + this.entry.getContentType());
        this.registryHelper.readEntry(this.path);
    }

    @Test
    public void testReadEntry() throws Exception {
        Mockito.when((Object)this.ioService.readAllString(this.path)).thenReturn((Object)MARSHALLED_ENTRY);
        Mockito.when((Object)this.entryMarshaller.unmarshal(MARSHALLED_ENTRY)).thenReturn((Object)this.entry);
        Mockito.when((Object)this.entry.getContentType()).thenReturn((Object)Object.class.getName());
        Mockito.when((Object)this.entry.getContent()).thenReturn((Object)MARSHALLED_VALUE);
        Mockito.when((Object)this.marshallerRegistry.get((Class)Mockito.any(Class.class))).thenReturn((Object)this.marshaller);
        Object unmarshalledValue = Mockito.mock(Object.class);
        Mockito.when((Object)this.marshaller.unmarshal(MARSHALLED_VALUE)).thenReturn(unmarshalledValue);
        Object result = this.registryHelper.readEntry(this.path);
        Assert.assertEquals((Object)unmarshalledValue, (Object)result);
    }

    @Test
    public void testReadEntries() throws Exception {
        this.prepareReadEntries();
        List result = this.registryHelper.readEntries(this.rootPath, this.filter);
        Assert.assertEquals(this.expectedObjects, (Object)result);
        for (Path path : this.entryPaths) {
            ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1))).readEntry(path);
        }
    }

    @Test
    public void testReadEntriesWithError() throws Exception {
        this.prepareReadEntries();
        int failingIndex = 5;
        Mockito.when((Object)this.marshaller.unmarshal(this.entries.get(failingIndex).getContent())).thenThrow(new Throwable[]{new IOException(ERROR_MESSAGE)});
        this.expectedException.expectMessage(ERROR_MESSAGE);
        this.registryHelper.readEntries(this.rootPath, this.filter);
        for (int i = 0; i < failingIndex; ++i) {
            Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1));
        }
    }

    @Test
    public void testWriteBatch() {
        Mockito.when((Object)this.path.getFileSystem()).thenReturn((Object)this.fileSystem);
        this.registryHelper.writeBatch(this.path, MARSHALLED_VALUE);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write(this.path, MARSHALLED_VALUE, new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
    }

    @Test
    public void testDeleteBatch() {
        Mockito.when((Object)this.path.getFileSystem()).thenReturn((Object)this.fileSystem);
        this.registryHelper.deleteBatch(this.path);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).deleteIfExists(this.path, new DeleteOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
    }

    private void prepareReadEntries() throws Exception {
        this.entryPaths = AlaSPITestCommons.mockList(Path.class, (int)10);
        Iterator<Path> pathIterator = this.entryPaths.iterator();
        this.expectedObjects = AlaSPITestCommons.mockList(Object.class, (int)10);
        this.entries = AlaSPITestCommons.mockList(VFSRegistryEntry.class, (int)10);
        DirectoryStream directoryStream = (DirectoryStream)Mockito.mock(DirectoryStream.class);
        Mockito.when((Object)directoryStream.iterator()).thenReturn(pathIterator);
        Mockito.when((Object)this.ioService.newDirectoryStream(this.rootPath, this.filter)).thenReturn((Object)directoryStream);
        for (int i = 0; i < 10; ++i) {
            VFSRegistryEntry entry = this.entries.get(i);
            Mockito.when((Object)this.ioService.readAllString(this.entryPaths.get(i))).thenReturn((Object)(MARSHALLED_ENTRY + i));
            Mockito.when((Object)this.entryMarshaller.unmarshal(MARSHALLED_ENTRY + i)).thenReturn((Object)entry);
            Mockito.when((Object)entry.getContentType()).thenReturn((Object)Object.class.getName());
            Mockito.when((Object)entry.getContent()).thenReturn((Object)(MARSHALLED_VALUE + i));
            Mockito.when((Object)this.marshallerRegistry.get((Class)Mockito.any(Class.class))).thenReturn((Object)this.marshaller);
            Mockito.when((Object)this.marshaller.unmarshal(MARSHALLED_VALUE + i)).thenReturn(this.expectedObjects.get(i));
        }
    }
}

