/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.vfs;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.codec.digest.DigestUtils;
import org.guvnor.ala.marshalling.Marshaller;
import org.guvnor.ala.registry.vfs.VFSMarshallerRegistry;
import org.guvnor.ala.registry.vfs.VFSRegistryEntry;
import org.guvnor.ala.registry.vfs.VFSRegistryEntryMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@ApplicationScoped
public class VFSRegistryHelper {
    protected static final String PROVISIONING_BRANCH = "master";
    protected static final String PROVISIONING_PATH = "provisioning";
    private static final Logger logger = LoggerFactory.getLogger(VFSRegistryHelper.class);
    private VFSMarshallerRegistry marshallerRegistry;
    private IOService ioService;
    private FileSystem fileSystem;
    private Path provisioningRootPath;
    private VFSRegistryEntryMarshaller entryMarshaller;

    public VFSRegistryHelper() {
    }

    @Inject
    public VFSRegistryHelper(VFSMarshallerRegistry marshallerRegistry, @Named(value="ioStrategy") IOService ioService, @Named(value="systemFS") FileSystem fileSystem) {
        this.marshallerRegistry = marshallerRegistry;
        this.ioService = ioService;
        this.fileSystem = fileSystem;
    }

    @PostConstruct
    protected void init() {
        try {
            this.provisioningRootPath = this.fileSystem.getPath(PROVISIONING_BRANCH, new String[]{PROVISIONING_PATH});
            logger.debug("provisioningRootPath: " + this.provisioningRootPath.toUri());
        }
        catch (Exception e) {
            logger.error("An error was produced during VFS registries directory initialization.", (Throwable)e);
        }
        this.entryMarshaller = (VFSRegistryEntryMarshaller)this.marshallerRegistry.get(VFSRegistryEntry.class);
    }

    public Path ensureDirectory(String directory) {
        Path directoryPath = this.provisioningRootPath.resolve(directory);
        if (!this.ioService.exists(directoryPath)) {
            directoryPath = this.ioService.createDirectory(directoryPath, new FileAttribute[0]);
        }
        return directoryPath;
    }

    public String md5Hex(String content) {
        if (content == null) {
            return "";
        }
        return DigestUtils.md5Hex((String)content);
    }

    public void storeEntry(Path path, Object value) throws Exception {
        Marshaller marshaller = this.marshallerRegistry.get(value.getClass());
        if (marshaller == null) {
            throw new Exception("No marshaller was found for class: " + value.getClass());
        }
        String marshalledValue = marshaller.marshal(value);
        VFSRegistryEntry entry = new VFSRegistryEntry(value.getClass().getName(), marshalledValue);
        String content = this.entryMarshaller.marshal(entry);
        this.writeBatch(path, content);
    }

    public Object readEntry(Path path) throws Exception {
        String entryContent = this.ioService.readAllString(path);
        VFSRegistryEntry entry = (VFSRegistryEntry)this.entryMarshaller.unmarshal(entryContent);
        Marshaller marshaller = this.marshallerRegistry.get(Class.forName(entry.getContentType()));
        if (marshaller == null) {
            throw new Exception("No marshaller was found for class: " + entry.getContentType());
        }
        return marshaller.unmarshal(entry.getContent());
    }

    public List<Object> readEntries(Path rootPath, DirectoryStream.Filter<Path> filter) throws Exception {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (Path path : this.ioService.newDirectoryStream(rootPath, filter)) {
            try {
                entries.add(this.readEntry(path));
            }
            catch (Exception e) {
                logger.error("An error was produced while processing entry for path: " + path, (Throwable)e);
                throw e;
            }
        }
        return entries;
    }

    public void writeBatch(Path path, String content) {
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.write(path, content, new OpenOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public void deleteBatch(Path path) {
        try {
            this.ioService.startBatch(path.getFileSystem());
            this.ioService.deleteIfExists(path, new DeleteOption[0]);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    public static class BySuffixFilter
    implements DirectoryStream.Filter<Path> {
        private String suffix;

        private BySuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        public static BySuffixFilter newFilter(String suffix) {
            return new BySuffixFilter(suffix);
        }

        public boolean accept(Path path) throws IOException {
            return path.getFileName().toString().endsWith(this.suffix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BySuffixFilter that = (BySuffixFilter)o;
            return this.suffix != null ? this.suffix.equals(that.suffix) : that.suffix == null;
        }

        public int hashCode() {
            return this.suffix != null ? this.suffix.hashCode() : 0;
        }
    }
}

