/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.vfs;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.AlaSPITestCommons;
import org.guvnor.ala.registry.inmemory.InMemoryRuntimeRegistry;
import org.guvnor.ala.registry.inmemory.InMemoryRuntimeRegistryTest;
import org.guvnor.ala.registry.vfs.VFSRegistryHelper;
import org.guvnor.ala.registry.vfs.VFSRuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class VFSRuntimeRegistryTest
extends InMemoryRuntimeRegistryTest {
    private static final String ID_MD5 = "ID_MD5";
    @Mock
    private VFSRegistryHelper registryHelper;
    @Mock
    private Path registryRoot;
    private List<Object> providers;
    private List<Object> runtimes;
    private Path providerTargetPath;
    private Path runtimeTargetPath;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        super.setUp();
        Mockito.when((Object)this.registryHelper.ensureDirectory("runtime-registry")).thenReturn((Object)this.registryRoot);
        this.runtimeRegistry = (InMemoryRuntimeRegistry)Mockito.spy((Object)new VFSRuntimeRegistry(this.registryHelper));
        ((VFSRuntimeRegistry)this.runtimeRegistry).init();
    }

    @Test
    public void testInit() throws Exception {
        this.providers = new ArrayList<Object>();
        this.providers.addAll(AlaSPITestCommons.mockProviderListSPI((ProviderType)this.providerType, (int)10));
        this.runtimes = new ArrayList<Object>();
        this.runtimes.addAll(this.mockRuntimeList(this.providerId, "", 10));
        Mockito.when((Object)this.registryHelper.readEntries(this.registryRoot, (DirectoryStream.Filter)VFSRegistryHelper.BySuffixFilter.newFilter((String)"-provider.entry"))).thenReturn(this.providers);
        Mockito.when((Object)this.registryHelper.readEntries(this.registryRoot, (DirectoryStream.Filter)VFSRegistryHelper.BySuffixFilter.newFilter((String)"-runtime.entry"))).thenReturn(this.runtimes);
        ((VFSRuntimeRegistry)this.runtimeRegistry).init();
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)2))).ensureDirectory("runtime-registry");
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)2))).readEntries(this.registryRoot, (DirectoryStream.Filter)VFSRegistryHelper.BySuffixFilter.newFilter((String)"-provider.entry"));
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)2))).readEntries(this.registryRoot, (DirectoryStream.Filter)VFSRegistryHelper.BySuffixFilter.newFilter((String)"-runtime.entry"));
        for (Object provider : this.providers) {
            this.verifyProviderIsRegistered((Provider)provider);
        }
        for (Object runtime : this.runtimes) {
            this.verifyRuntimeIsRegistered((Runtime)runtime);
        }
    }

    @Test
    public void testRegisterProvider() {
        this.prepareProviderTargetPath();
        this.runtimeRegistry.registerProvider(this.provider);
        try {
            ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1))).storeEntry(this.providerTargetPath, (Object)this.provider);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        this.verifyProviderIsRegistered(this.provider);
    }

    @Test
    public void testRegisterProviderWhenMarshallingErrors() throws Exception {
        this.prepareProviderTargetPath();
        this.expectedException.expectMessage("Unexpected error was produced during provider marshalling/storing, provider: " + this.provider);
        ((VFSRegistryHelper)Mockito.doThrow((Throwable[])new Throwable[]{new Exception("no matter the message here")}).when((Object)this.registryHelper)).storeEntry(this.providerTargetPath, (Object)this.provider);
        this.runtimeRegistry.registerProvider(this.provider);
    }

    @Test
    public void testDeregisterProvider() {
        this.prepareProviderTargetPath();
        this.runtimeRegistry.registerProvider(this.provider);
        this.verifyProviderIsRegistered(this.provider);
        this.runtimeRegistry.deregisterProvider(this.provider);
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1))).deleteBatch(this.providerTargetPath);
        this.verifyProviderIsNotRegistered(this.provider);
    }

    @Test
    public void testDeregisterProviderById() {
        this.prepareProviderTargetPath();
        this.runtimeRegistry.registerProvider(this.provider);
        this.verifyProviderIsRegistered(this.provider);
        this.runtimeRegistry.deregisterProvider(this.provider.getId());
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1))).deleteBatch(this.providerTargetPath);
        this.verifyProviderIsNotRegistered(this.provider);
    }

    private void prepareProviderTargetPath() {
        this.providerTargetPath = this.prepareTargetPath(this.provider.getId(), "-provider.entry");
    }

    @Test
    public void testRegisterRuntime() {
        this.prepareRuntimeTargetPath();
        this.runtimeRegistry.registerRuntime(this.runtime);
        try {
            ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1))).storeEntry(this.runtimeTargetPath, (Object)this.runtime);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        this.verifyRuntimeIsRegistered(this.runtime);
    }

    @Test
    public void testRegisterRuntimeWhenMarshallingErrors() throws Exception {
        this.prepareRuntimeTargetPath();
        this.expectedException.expectMessage("Unexpected error was produced during runtime marshalling/storing, runtime: " + this.runtime);
        ((VFSRegistryHelper)Mockito.doThrow((Throwable[])new Throwable[]{new Exception("no matter the message here")}).when((Object)this.registryHelper)).storeEntry(this.runtimeTargetPath, (Object)this.runtime);
        this.runtimeRegistry.registerRuntime(this.runtime);
    }

    @Test
    public void testDeregisterRuntime() {
        this.prepareRuntimeTargetPath();
        this.runtimeRegistry.registerRuntime(this.runtime);
        this.verifyRuntimeIsRegistered(this.runtime);
        this.runtimeRegistry.deregisterRuntime((RuntimeId)this.runtime);
        ((VFSRegistryHelper)Mockito.verify((Object)this.registryHelper, (VerificationMode)Mockito.times((int)1))).deleteBatch(this.runtimeTargetPath);
        this.verifyRuntimeIsNotRegistered(this.runtime);
    }

    private void prepareRuntimeTargetPath() {
        this.runtimeTargetPath = this.prepareTargetPath(this.runtime.getId(), "-runtime.entry");
    }

    private Path prepareTargetPath(String id, String suffix) {
        Mockito.when((Object)this.registryHelper.md5Hex(id)).thenReturn((Object)ID_MD5);
        String expectedPath = ID_MD5 + suffix;
        Path targetPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.registryRoot.resolve(expectedPath)).thenReturn((Object)targetPath);
        return targetPath;
    }
}

