/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.vfs;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Specializes;
import javax.inject.Inject;
import org.guvnor.ala.registry.inmemory.InMemoryRuntimeRegistry;
import org.guvnor.ala.registry.vfs.VFSRegistryHelper;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.providers.Provider;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
@Specializes
public class VFSRuntimeRegistry
extends InMemoryRuntimeRegistry {
    protected static final String RUNTIME_REGISTRY_PATH = "runtime-registry";
    protected static final String PROVIDER_SUFFIX = "-provider.entry";
    protected static final String RUNTIME_SUFFIX = "-runtime.entry";
    private static final Logger logger = LoggerFactory.getLogger(VFSRuntimeRegistry.class);
    private VFSRegistryHelper registryHelper;
    private Path registryRoot;

    public VFSRuntimeRegistry() {
    }

    @Inject
    public VFSRuntimeRegistry(VFSRegistryHelper registryHelper) {
        this.registryHelper = registryHelper;
    }

    @PostConstruct
    protected void init() {
        this.initializeRegistryRoot();
        this.initializeRegistry();
    }

    public void registerProvider(Provider provider) {
        PortablePreconditions.checkNotNull((String)"provider", (Object)provider);
        Path path = this.buildProviderPath(provider.getId());
        try {
            this.registryHelper.storeEntry(path, provider);
        }
        catch (Exception e) {
            logger.error("Unexpected error was produced during provider marshalling/storing, provider: " + provider, (Throwable)e);
            throw new RuntimeException("Unexpected error was produced during provider marshalling/storing, provider: " + provider, e);
        }
        super.registerProvider(provider);
    }

    public void deregisterProvider(Provider provider) {
        PortablePreconditions.checkNotNull((String)"provider", (Object)provider);
        this.deregisterProvider(provider.getId());
    }

    public void deregisterProvider(String providerId) {
        PortablePreconditions.checkNotNull((String)"providerId", (Object)providerId);
        Path path = this.buildProviderPath(providerId);
        this.registryHelper.deleteBatch(path);
        super.deregisterProvider(providerId);
    }

    public void registerRuntime(Runtime runtime) {
        PortablePreconditions.checkNotNull((String)"runtime", (Object)runtime);
        Path path = this.buildRuntimePath(runtime.getId());
        try {
            this.registryHelper.storeEntry(path, runtime);
        }
        catch (Exception e) {
            logger.error("Unexpected error was produced during runtime marshalling/storing, runtime: " + runtime, (Throwable)e);
            throw new RuntimeException("Unexpected error was produced during runtime marshalling/storing, runtime: " + runtime, e);
        }
        super.registerRuntime(runtime);
    }

    public void deregisterRuntime(RuntimeId runtimeId) {
        PortablePreconditions.checkNotNull((String)"runtimeId", (Object)runtimeId);
        Path path = this.buildRuntimePath(runtimeId.getId());
        this.registryHelper.deleteBatch(path);
        super.deregisterRuntime(runtimeId);
    }

    private void initializeRegistryRoot() {
        try {
            this.registryRoot = this.registryHelper.ensureDirectory(RUNTIME_REGISTRY_PATH);
        }
        catch (Exception e) {
            logger.error("An error was produced during " + VFSRuntimeRegistry.class.getName() + " directories initialization.", (Throwable)e);
        }
    }

    private void initializeRegistry() {
        try {
            List<Object> providers = this.registryHelper.readEntries(this.registryRoot, VFSRegistryHelper.BySuffixFilter.newFilter(PROVIDER_SUFFIX));
            providers.forEach(provider -> super.registerProvider((Provider)provider));
            List<Object> runtimes = this.registryHelper.readEntries(this.registryRoot, VFSRegistryHelper.BySuffixFilter.newFilter(RUNTIME_SUFFIX));
            runtimes.forEach(runtime -> super.registerRuntime((Runtime)runtime));
        }
        catch (Exception e) {
            logger.error("An error was produced during " + VFSRuntimeRegistry.class.getName() + " initialization.", (Throwable)e);
        }
    }

    private Path buildProviderPath(String providerId) {
        return this.registryRoot.resolve(this.registryHelper.md5Hex(providerId) + PROVIDER_SUFFIX);
    }

    private Path buildRuntimePath(String runtimeId) {
        return this.registryRoot.resolve(this.registryHelper.md5Hex(runtimeId) + RUNTIME_SUFFIX);
    }
}

