/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.source.git;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.guvnor.ala.exceptions.SourcingException;
import org.guvnor.ala.source.Host;
import org.guvnor.ala.source.Repository;
import org.guvnor.ala.source.Source;
import org.guvnor.ala.source.git.GitCredentials;
import org.guvnor.ala.source.git.model.GitSource;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.commons.config.ConfigProperties;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystems;
import org.uberfire.java.nio.file.Path;

public class GitRepository
implements Repository {
    private final Host host;
    private final String id;
    private final String name;
    private final URI uri;
    private final GitCredentials credentials;
    private final String bareRepoDir;
    private final Map<String, String> env = new HashMap<String, String>();
    private FileSystem fileSystem = null;

    public GitRepository(Host host, String id, String name, URI uri, GitCredentials credentials, Map<String, String> env, ConfigProperties config) {
        this.host = (Host)PortablePreconditions.checkNotNull((String)"host", (Object)host);
        this.id = PortablePreconditions.checkNotEmpty((String)"id", (String)id);
        this.name = PortablePreconditions.checkNotEmpty((String)"name", (String)name);
        this.uri = (URI)PortablePreconditions.checkNotNull((String)"uri", (Object)uri);
        this.credentials = (GitCredentials)PortablePreconditions.checkNotNull((String)"credentials", (Object)credentials);
        if (env != null && !env.isEmpty()) {
            this.env.putAll(env);
        }
        PortablePreconditions.checkNotNull((String)"config", (Object)config);
        ConfigProperties.ConfigProperty currentDirectory = config.get("user.dir", null);
        this.bareRepoDir = config.get("org.uberfire.provisioning.git.dir", currentDirectory.getValue()).getValue();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Source getSource() {
        return this.getSource("master", new String[0]);
    }

    public Source getSource(String _root, String ... _path) throws SourcingException {
        if (this.fileSystem == null) {
            URI fsURI = URI.create("git://" + this.name);
            try {
                this.fileSystem = FileSystems.newFileSystem((URI)fsURI, (Map)new HashMap<String, Object>(this.env){
                    {
                        this.putIfAbsent("origin", GitRepository.this.uri.toString());
                        this.putIfAbsent("out-dir", GitRepository.this.bareRepoDir);
                        if (GitRepository.this.credentials.getUser() != null) {
                            this.putIfAbsent("username", GitRepository.this.credentials.getUser());
                            this.putIfAbsent("password", GitRepository.this.credentials.getPassw());
                        }
                    }
                });
            }
            catch (FileSystemAlreadyExistsException fsae) {
                try {
                    this.fileSystem = FileSystems.getFileSystem((URI)fsURI);
                }
                catch (Exception ex) {
                    throw new SourcingException("Error Getting Source", (Throwable)ex);
                }
            }
        }
        String root = _root == null || _root.isEmpty() ? "master" : _root;
        String[] path = _path == null || _path.length == 0 ? new String[]{"/"} : _path;
        Path result = this.fileSystem.getPath(root, path);
        return new GitSource(this, result);
    }
}

