/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.source.git.executor;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.pipeline.FunctionConfigExecutor;
import org.guvnor.ala.registry.SourceRegistry;
import org.guvnor.ala.source.Repository;
import org.guvnor.ala.source.Source;
import org.guvnor.ala.source.git.GitRepository;
import org.guvnor.ala.source.git.UFLocal;
import org.guvnor.ala.source.git.config.GitConfig;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.file.FileSystems;

public class GitConfigExecutor
implements FunctionConfigExecutor<GitConfig, Source> {
    private final SourceRegistry sourceRegistry;

    @Inject
    public GitConfigExecutor(SourceRegistry sourceRegistry) {
        this.sourceRegistry = sourceRegistry;
    }

    public Optional<Source> apply(final GitConfig gitConfig) {
        URI uri;
        PortablePreconditions.checkNotEmpty((String)"repo-name parameter is mandatory", (String)gitConfig.getRepoName());
        if (Boolean.parseBoolean(gitConfig.getCreateRepo())) {
            uri = URI.create("git://" + gitConfig.getRepoName());
            FileSystems.newFileSystem((URI)uri, (Map)new HashMap<String, Object>(){
                {
                    if (gitConfig.getOrigin() != null && !gitConfig.getOrigin().isEmpty()) {
                        this.put("origin", gitConfig.getOrigin());
                    } else {
                        this.put("init", Boolean.TRUE);
                    }
                    if (gitConfig.getOutPath() != null && !gitConfig.getOutPath().isEmpty()) {
                        this.put("out-dir", gitConfig.getOutPath());
                    }
                }
            });
        } else {
            uri = URI.create("git://" + gitConfig.getRepoName() + "?sync");
            try {
                FileSystems.getFileSystem((URI)uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GitRepository gitRepository = (GitRepository)new UFLocal().getRepository(gitConfig.getRepoName(), Collections.emptyMap());
        Optional<Source> source_ = Optional.ofNullable(gitRepository.getSource(gitConfig.getBranch() != null && !gitConfig.getBranch().isEmpty() ? gitConfig.getBranch() : "master", new String[0]));
        if (source_.isPresent()) {
            Source source = source_.get();
            this.sourceRegistry.registerRepositorySources(source.getPath(), (Repository)gitRepository);
            this.sourceRegistry.registerSource((Repository)gitRepository, source);
        }
        return source_;
    }

    public Class<? extends Config> executeFor() {
        return GitConfig.class;
    }

    public String outputId() {
        return "source";
    }

    public String inputId() {
        return "git-config";
    }
}

