/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.ala.ui.model;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;

/**
 * This class holds the information about a pipeline error and the errorDetail.
 */
@Portable
public class PipelineError {

    private String error;

    private String errorDetail;

    public PipelineError(@MapsTo("error") final String error,
                         @MapsTo("errorDetail") final String errorDetail) {
        this.error = error;
        this.errorDetail = errorDetail;
    }

    public String getError() {
        return error;
    }

    public String getErrorDetail() {
        return errorDetail;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        PipelineError that = (PipelineError) o;

        if (error != null ? !error.equals(that.error) : that.error != null) {
            return false;
        }
        return errorDetail != null ? errorDetail.equals(that.errorDetail) : that.errorDetail == null;
    }

    @Override
    public int hashCode() {
        int result = error != null ? error.hashCode() : 0;
        result = ~~result;
        result = 31 * result + (errorDetail != null ? errorDetail.hashCode() : 0);
        result = ~~result;
        return result;
    }
}
