/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.handler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.guvnor.ala.ui.handler.ProviderHandler;
import org.guvnor.ala.ui.model.ProviderTypeKey;

public abstract class AbstractProviderHandlerRegistry<T extends ProviderHandler> {
    protected List<T> handlers = new ArrayList<T>();

    protected AbstractProviderHandlerRegistry() {
    }

    protected AbstractProviderHandlerRegistry(Instance<T> handlerInstance) {
        handlerInstance.iterator().forEachRemaining(this.handlers::add);
    }

    public boolean isProviderInstalled(ProviderTypeKey providerTypeKey) {
        return this.getProviderHandler(providerTypeKey) != null;
    }

    public T getProviderHandler(ProviderTypeKey providerTypeKey) {
        return (T)((ProviderHandler)this.handlers.stream().filter(handler -> handler.acceptProviderType(providerTypeKey)).sorted(Comparator.comparingInt(ProviderHandler::getPriority)).findFirst().orElse(null));
    }
}

