/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.RuntimeQuery;
import org.guvnor.ala.services.api.RuntimeQueryBuilder;
import org.guvnor.ala.services.api.RuntimeQueryResultItem;
import org.guvnor.ala.services.api.backend.PipelineServiceBackend;
import org.guvnor.ala.services.api.backend.RuntimeProvisioningServiceBackend;
import org.guvnor.ala.ui.backend.service.PipelineInputBuilder;
import org.guvnor.ala.ui.backend.service.RuntimeListItemBuilder;
import org.guvnor.ala.ui.events.PipelineExecutionChange;
import org.guvnor.ala.ui.events.PipelineExecutionChangeEvent;
import org.guvnor.ala.ui.events.RuntimeChange;
import org.guvnor.ala.ui.events.RuntimeChangeEvent;
import org.guvnor.ala.ui.exceptions.ServiceException;
import org.guvnor.ala.ui.model.PipelineExecutionTraceKey;
import org.guvnor.ala.ui.model.PipelineKey;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.RuntimeKey;
import org.guvnor.ala.ui.model.RuntimeListItem;
import org.guvnor.ala.ui.service.ProviderService;
import org.guvnor.ala.ui.service.RuntimeService;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@ApplicationScoped
public class RuntimeServiceImpl
implements RuntimeService {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeServiceImpl.class);
    private RuntimeProvisioningServiceBackend runtimeProvisioningService;
    private PipelineServiceBackend pipelineService;
    private ProviderService providerService;
    private Event<RuntimeChangeEvent> runtimeChangeEvent;
    private Event<PipelineExecutionChangeEvent> pipelineExecutionChangeEvent;

    public RuntimeServiceImpl() {
    }

    @Inject
    public RuntimeServiceImpl(RuntimeProvisioningServiceBackend runtimeProvisioningService, PipelineServiceBackend pipelineService, ProviderService providerService, Event<RuntimeChangeEvent> runtimeChangeEvent, Event<PipelineExecutionChangeEvent> pipelineExecutionChangeEvent) {
        this.runtimeProvisioningService = runtimeProvisioningService;
        this.pipelineService = pipelineService;
        this.providerService = providerService;
        this.runtimeChangeEvent = runtimeChangeEvent;
        this.pipelineExecutionChangeEvent = pipelineExecutionChangeEvent;
    }

    public Collection<RuntimeListItem> getRuntimeItems(ProviderKey providerKey) {
        PortablePreconditions.checkNotNull((String)"providerKey", (Object)providerKey);
        RuntimeQuery query = RuntimeQueryBuilder.newInstance().withProviderId(providerKey.getId()).build();
        return this.buildRuntimeQueryResult(this.runtimeProvisioningService.executeQuery(query));
    }

    public RuntimeListItem getRuntimeItem(PipelineExecutionTraceKey pipelineExecutionTraceKey) {
        PortablePreconditions.checkNotNull((String)"pipelineExecutionTraceKey", (Object)pipelineExecutionTraceKey);
        RuntimeQuery query = RuntimeQueryBuilder.newInstance().withPipelineExecutionId(pipelineExecutionTraceKey.getId()).build();
        return this.buildRuntimeQueryResult(this.runtimeProvisioningService.executeQuery(query)).stream().findFirst().orElse(null);
    }

    public RuntimeListItem getRuntimeItem(RuntimeKey runtimeKey) {
        PortablePreconditions.checkNotNull((String)"runtimeKey", (Object)runtimeKey);
        RuntimeQuery query = RuntimeQueryBuilder.newInstance().withRuntimeId(runtimeKey.getId()).build();
        return this.buildRuntimeQueryResult(this.runtimeProvisioningService.executeQuery(query)).stream().findFirst().orElse(null);
    }

    private Collection<RuntimeListItem> buildRuntimeQueryResult(List<RuntimeQueryResultItem> resultItems) {
        Collection result = resultItems.stream().map(item -> RuntimeListItemBuilder.newInstance().withItem((RuntimeQueryResultItem)item).build()).collect(Collectors.toList());
        return result;
    }

    public Collection<PipelineKey> getPipelines(final ProviderTypeKey providerTypeKey) {
        PortablePreconditions.checkNotNull((String)"providerTypeKey", (Object)providerTypeKey);
        return this.pipelineService.getPipelineNames(new ProviderType(){

            public String getProviderTypeName() {
                return providerTypeKey.getId();
            }

            public String getVersion() {
                return providerTypeKey.getVersion();
            }
        }, Integer.valueOf(0), Integer.valueOf(1000), "name", true).stream().map(PipelineKey::new).collect(Collectors.toList());
    }

    public PipelineExecutionTraceKey createRuntime(ProviderKey providerKey, String runtimeName, PipelineKey pipelineKey, Map<String, String> params) {
        PortablePreconditions.checkNotNull((String)"providerKey", (Object)providerKey);
        PortablePreconditions.checkNotNull((String)"runtimeName", (Object)runtimeName);
        PortablePreconditions.checkNotNull((String)"pipelineKey", (Object)pipelineKey);
        this.validateForCreateRuntime(providerKey, runtimeName);
        try {
            Input input = PipelineInputBuilder.newInstance().withRuntimeName(runtimeName).withProvider(providerKey).withParams(params).build();
            return new PipelineExecutionTraceKey(this.pipelineService.runPipeline(pipelineKey.getId(), input, true));
        }
        catch (Exception e) {
            logger.error("Runtime creation failed.", (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void stopPipelineExecution(PipelineExecutionTraceKey pipelineExecutionTraceKey) {
        PortablePreconditions.checkNotNull((String)"pipelineExecutionTraceKey", (Object)pipelineExecutionTraceKey);
        this.pipelineService.stopPipelineExecution(pipelineExecutionTraceKey.getId());
        this.pipelineExecutionChangeEvent.fire((Object)new PipelineExecutionChangeEvent(PipelineExecutionChange.STOPPED, pipelineExecutionTraceKey));
    }

    public void deletePipelineExecution(PipelineExecutionTraceKey pipelineExecutionTraceKey) {
        PortablePreconditions.checkNotNull((String)"pipelineExecutionTraceKey", (Object)pipelineExecutionTraceKey);
        this.pipelineService.deletePipelineExecution(pipelineExecutionTraceKey.getId());
        this.pipelineExecutionChangeEvent.fire((Object)new PipelineExecutionChangeEvent(PipelineExecutionChange.DELETED, pipelineExecutionTraceKey));
    }

    public void stopRuntime(RuntimeKey runtimeKey) {
        PortablePreconditions.checkNotNull((String)"runtimeKey", (Object)runtimeKey);
        this.runtimeProvisioningService.stopRuntime(runtimeKey.getId());
        this.runtimeChangeEvent.fire((Object)new RuntimeChangeEvent(RuntimeChange.STOPPED, runtimeKey));
    }

    public void startRuntime(RuntimeKey runtimeKey) {
        PortablePreconditions.checkNotNull((String)"runtimeKey", (Object)runtimeKey);
        this.runtimeProvisioningService.startRuntime(runtimeKey.getId());
        this.runtimeChangeEvent.fire((Object)new RuntimeChangeEvent(RuntimeChange.STARTED, runtimeKey));
    }

    public void deleteRuntime(RuntimeKey runtimeKey, boolean forced) {
        PortablePreconditions.checkNotNull((String)"runtimeKey", (Object)runtimeKey);
        this.runtimeProvisioningService.destroyRuntime(runtimeKey.getId(), forced);
        this.runtimeChangeEvent.fire((Object)new RuntimeChangeEvent(RuntimeChange.DELETED, runtimeKey));
    }

    private void validateForCreateRuntime(ProviderKey providerKey, String runtimeName) {
        Provider provider = this.providerService.getProvider(providerKey);
        if (provider == null) {
            logger.error("No provider was found for providerKey: " + providerKey);
            throw new ServiceException("No provider was found for providerKey: " + providerKey);
        }
        List items = this.runtimeProvisioningService.executeQuery(RuntimeQueryBuilder.newInstance().withRuntimeName(runtimeName).build());
        if (!items.isEmpty()) {
            throw new ServiceException("A runtime with the given name already exists: " + runtimeName);
        }
    }
}

