/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.wildfly.client.handler;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.handler.ClientProviderHandler;
import org.guvnor.ala.ui.client.handler.FormResolver;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.wildfly.client.handler.WildflyFormResolver;
import org.guvnor.ala.ui.wildfly.client.resources.images.GuvnorAlaWildflyUIImageResources;

@ApplicationScoped
public class WildflyClientProviderHandler
implements ClientProviderHandler {
    private static final String PROVIDER_TYPE_NAME = "wildfly";
    private WildflyFormResolver formResolver;

    @Inject
    public WildflyClientProviderHandler(WildflyFormResolver formResolver) {
        this.formResolver = formResolver;
    }

    public int getPriority() {
        return 1;
    }

    public boolean acceptProviderType(ProviderTypeKey providerTypeKey) {
        return providerTypeKey != null && PROVIDER_TYPE_NAME.equals(providerTypeKey.getId());
    }

    public FormResolver getFormResolver() {
        return this.formResolver;
    }

    public String getProviderTypeImageURL() {
        return GuvnorAlaWildflyUIImageResources.INSTANCE.providerIcon().getSafeUri().asString();
    }
}

