/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.wildfly.client.provider;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.ala.ui.client.handler.ProviderConfigurationForm;
import org.guvnor.ala.ui.client.util.AbstractHasContentChangeHandlers;
import org.guvnor.ala.ui.client.util.UIUtil;
import org.guvnor.ala.ui.client.widget.FormStatus;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderConfiguration;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.wildfly.service.TestConnectionResult;
import org.guvnor.ala.ui.wildfly.service.WildflyClientService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class WF10ProviderConfigPresenter
extends AbstractHasContentChangeHandlers
implements ProviderConfigurationForm {
    protected static final String HOST = "host";
    protected static final String PORT = "port";
    protected static final String MANAGEMENT_PORT = "management-port";
    protected static final String USER = "wildfly-user";
    protected static final String PASSWORD = "wildfly-password";
    protected static final String PASSWORD_MASK = "****";
    private final View view;
    private final Caller<WildflyClientService> wildflyClientService;

    @Inject
    public WF10ProviderConfigPresenter(View view, Caller<WildflyClientService> wildflyClientService) {
        this.view = view;
        this.wildflyClientService = wildflyClientService;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    public View getView() {
        return this.view;
    }

    public ProviderConfiguration buildProviderConfiguration() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(HOST, this.getHost());
        values.put(PORT, this.getPort());
        values.put(MANAGEMENT_PORT, this.getManagementPort());
        values.put(USER, this.getUsername());
        values.put(PASSWORD, this.getPassword());
        return new ProviderConfiguration(this.getProviderName(), values);
    }

    public void clear() {
        this.view.clear();
    }

    public void load(Provider provider) {
        this.clear();
        this.view.setProviderName(((ProviderKey)provider.getKey()).getId());
        this.view.setHost(UIUtil.getStringValue((Map)provider.getConfiguration().getValues(), (String)HOST));
        this.view.setPort(UIUtil.getStringValue((Map)provider.getConfiguration().getValues(), (String)PORT));
        this.view.setManagementPort(UIUtil.getStringValue((Map)provider.getConfiguration().getValues(), (String)MANAGEMENT_PORT));
        this.view.setUsername(UIUtil.getStringValue((Map)provider.getConfiguration().getValues(), (String)USER));
        this.view.setPassword(PASSWORD_MASK);
    }

    public String getProviderName() {
        return this.view.getProviderName();
    }

    public String getHost() {
        return this.view.getHost();
    }

    public String getPort() {
        return this.view.getPort();
    }

    public String getManagementPort() {
        return this.view.getManagementPort();
    }

    public String getUsername() {
        return this.view.getUsername();
    }

    public String getPassword() {
        return this.view.getPassword();
    }

    public void isValid(Callback<Boolean> callback) {
        boolean isValid = !this.isEmpty(this.view.getProviderName()) && !this.isEmpty(this.view.getHost()) && this.isValidPort(this.view.getPort()) && this.isValidPort(this.view.getManagementPort()) && !this.isEmpty(this.view.getUsername()) && !this.isEmpty(this.view.getPassword());
        callback.callback((Object)isValid);
    }

    public String getWizardTitle() {
        return this.view.getWizardTitle();
    }

    public void disable() {
        this.view.disable();
    }

    private void onContentChange() {
        this.fireChangeHandlers();
    }

    protected void onProviderNameChange() {
        if (!this.isEmpty(this.view.getProviderName())) {
            this.view.setProviderNameStatus(FormStatus.VALID);
        } else {
            this.view.setProviderNameStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onHostChange() {
        if (!this.isEmpty(this.view.getHost())) {
            this.view.setHostStatus(FormStatus.VALID);
        } else {
            this.view.setHostStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onPortChange() {
        if (this.isValidPort(this.view.getPort())) {
            this.view.setPortStatus(FormStatus.VALID);
        } else {
            this.view.setPortStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onManagementPortChange() {
        if (this.isValidPort(this.view.getManagementPort())) {
            this.view.setManagementPortStatus(FormStatus.VALID);
        } else {
            this.view.setManagementPortStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onUserNameChange() {
        if (!this.isEmpty(this.view.getUsername())) {
            this.view.setUsernameStatus(FormStatus.VALID);
        } else {
            this.view.setUsernameStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onPasswordChange() {
        if (!this.isEmpty(this.view.getPassword())) {
            this.view.setPasswordStatus(FormStatus.VALID);
        } else {
            this.view.setPasswordStatus(FormStatus.ERROR);
        }
        this.onContentChange();
    }

    protected void onTestConnection() {
        if (this.validateRemoteParams()) {
            ((WildflyClientService)this.wildflyClientService.call(this.getTestConnectionSuccessCallback(), this.getTestConnectionErrorCallback())).testConnection(this.view.getHost(), this.getInt(this.view.getPort()), this.getInt(this.view.getManagementPort()), this.view.getUsername(), this.view.getPassword());
        }
    }

    private RemoteCallback<TestConnectionResult> getTestConnectionSuccessCallback() {
        return response -> {
            if (response.getManagementConnectionError()) {
                this.view.showInformationPopup(this.view.getTestConnectionFailMessage(response.getManagementConnectionMessage()));
            } else {
                this.view.showInformationPopup(this.view.getTestConnectionSuccessfulMessage(response.getManagementConnectionMessage()));
            }
        };
    }

    private ErrorCallback<Message> getTestConnectionErrorCallback() {
        return (message, throwable) -> {
            this.view.showErrorPopup(this.view.getTestConnectionUnExpectedErrorMessage(throwable.getMessage()));
            return false;
        };
    }

    private boolean validateRemoteParams() {
        boolean result;
        boolean bl = result = !this.isEmpty(this.view.getHost()) && this.isValidPort(this.view.getPort()) && this.isValidPort(this.view.getManagementPort()) && !this.isEmpty(this.view.getUsername()) && !this.isEmpty(this.view.getPassword());
        if (!result) {
            this.view.showInformationPopup(this.view.getParamsNotCompletedErrorMessage());
            return false;
        }
        return true;
    }

    private boolean isValidPort(String port) {
        int value = this.getInt(port);
        return value > 0 && value <= 65535;
    }

    private int getInt(String port) {
        if (port == null || port.trim().isEmpty()) {
            return -1;
        }
        int value = -1;
        try {
            value = Integer.parseInt(port.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static interface View
    extends UberElement<WF10ProviderConfigPresenter> {
        public String getProviderName();

        public String getHost();

        public String getPort();

        public String getManagementPort();

        public String getUsername();

        public String getPassword();

        public void setProviderName(String var1);

        public void setHost(String var1);

        public void setPort(String var1);

        public void setManagementPort(String var1);

        public void setUsername(String var1);

        public void setPassword(String var1);

        public void disable();

        public void enable();

        public void setProviderNameStatus(FormStatus var1);

        public void setHostStatus(FormStatus var1);

        public void setPortStatus(FormStatus var1);

        public void setManagementPortStatus(FormStatus var1);

        public void setUsernameStatus(FormStatus var1);

        public void setPasswordStatus(FormStatus var1);

        public void clear();

        public String getWizardTitle();

        public String getParamsNotCompletedErrorMessage();

        public String getTestConnectionFailMessage(String var1);

        public String getTestConnectionSuccessfulMessage(String var1);

        public String getTestConnectionUnExpectedErrorMessage(String var1);

        public void showInformationPopup(String var1);

        public void showErrorPopup(String var1);
    }
}

