/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.migration.cli;

import java.io.File;
import java.nio.file.Path;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.project.WorkspaceProjectMigrationService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.migration.cli.TemporaryNiogitService;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.spaces.Space;

@RunWith(value=MockitoJUnitRunner.class)
public class TemporaryNiogitServiceTest {
    TemporaryNiogitService service;
    @Mock
    OrganizationalUnitService ouService;
    @Mock
    RepositoryService repoService;
    @Mock
    WorkspaceProjectService projectService;
    @Mock
    WorkspaceProjectMigrationService migrationService;
    @Captor
    ArgumentCaptor<WorkspaceProject> projectCaptor;
    @Captor
    ArgumentCaptor<RepositoryEnvironmentConfigurations> configsCaptor;
    Path target;

    @Before
    public void setup() {
        this.service = new TemporaryNiogitService(this.ouService, this.repoService, this.projectService, this.migrationService);
        this.target = new File("fake/path").toPath();
        Mockito.when((Object)this.ouService.createOrganizationalUnit((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).then(inv -> {
            String name = (String)inv.getArgumentAt(0, String.class);
            String owner = (String)inv.getArgumentAt(1, String.class);
            String defaultGroupId = (String)inv.getArgumentAt(2, String.class);
            return new OrganizationalUnitImpl(name, owner, defaultGroupId);
        });
        Mockito.when((Object)this.repoService.createRepository((OrganizationalUnit)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (RepositoryEnvironmentConfigurations)Matchers.any())).then(inv -> {
            String alias = (String)inv.getArgumentAt(2, String.class);
            Space space = new Space(((OrganizationalUnit)inv.getArgumentAt(0, OrganizationalUnit.class)).getName());
            return new GitRepository(alias, space);
        });
        Mockito.when((Object)this.projectService.resolveProject((Repository)Matchers.any(Repository.class))).then(inv -> {
            WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
            Mockito.when((Object)project.getRepository()).thenReturn(inv.getArgumentAt(0, Repository.class));
            return project;
        });
    }

    @Test
    public void removeMigrationRepoAfterMigration() throws Exception {
        this.service.importProjects(this.target);
        ((RepositoryService)Mockito.verify((Object)this.repoService)).removeRepository((Space)Matchers.eq((Object)new Space("migrationSpace")), (String)Matchers.eq((Object)"migrationRepo"));
    }

    @Test
    public void migrateCalledOnLegacyProject() throws Exception {
        this.service.importProjects(this.target);
        ((WorkspaceProjectMigrationService)Mockito.verify((Object)this.migrationService)).migrate((WorkspaceProject)this.projectCaptor.capture());
        WorkspaceProject migrated = (WorkspaceProject)this.projectCaptor.getValue();
        Assert.assertEquals((Object)"migrationRepo", (Object)migrated.getRepository().getAlias());
    }

    @Test
    public void repoConfigurationHasOriginAndAvoidIndex() throws Exception {
        this.service.importProjects(this.target);
        ((RepositoryService)Mockito.verify((Object)this.repoService)).createRepository((OrganizationalUnit)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (RepositoryEnvironmentConfigurations)this.configsCaptor.capture());
        RepositoryEnvironmentConfigurations configs = (RepositoryEnvironmentConfigurations)this.configsCaptor.getValue();
        Assert.assertEquals((Object)this.target.toUri().toString(), (Object)this.assertValue(configs.getOrigin(), String.class));
        Assert.assertEquals((Object)"true", configs.getConfigurationMap().get("avoid_index"));
    }

    private <T> T assertValue(Object origin, Class<T> clazz) {
        Assert.assertTrue((boolean)clazz.isInstance(origin));
        return clazz.cast(origin);
    }
}

