/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.migration.cli;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.project.WorkspaceProjectMigrationService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;

@Dependent
public class TemporaryNiogitService {
    static final String OU_OWNER = "admin";
    static final String OU_NAME = "migrationSpace";
    static final String TMP_REPO_ALIAS = "migrationRepo";
    private final RepositoryService repoService;
    private final WorkspaceProjectMigrationService migrationService;
    private final WorkspaceProjectService projectService;
    private final OrganizationalUnitService ouService;

    @Inject
    public TemporaryNiogitService(OrganizationalUnitService ouService, RepositoryService repoService, WorkspaceProjectService projectService, WorkspaceProjectMigrationService migrationService) {
        this.ouService = ouService;
        this.repoService = repoService;
        this.projectService = projectService;
        this.migrationService = migrationService;
    }

    public void importProjects(Path actualTarget) {
        OrganizationalUnit ou = this.ouService.createOrganizationalUnit(OU_NAME, "org.migration", Collections.emptyList(), Collections.singletonList(new Contributor(OU_OWNER, ContributorType.OWNER)));
        String repositoryURL = actualTarget.toUri().toString();
        RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
        Map configMap = configurations.getConfigurationMap();
        configMap.put("avoid_index", "true");
        configMap.put("origin", repositoryURL);
        Repository repo = this.repoService.createRepository(ou, GitRepository.SCHEME.toString(), TMP_REPO_ALIAS, configurations);
        WorkspaceProject project = this.projectService.resolveProject(repo);
        this.migrationService.migrate(project);
        this.repoService.removeRepository(ou.getSpace(), TMP_REPO_ALIAS);
    }
}

