/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.migration.cli;

import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.weld.environment.se.WeldContainer;

public class ContainerHandler {
    private final WeldContainer container;
    private final Throwable initError;

    public ContainerHandler(Supplier<WeldContainer> provider) {
        WeldContainer container = null;
        Throwable initError = null;
        try {
            container = provider.get();
        }
        catch (Throwable t) {
            container = null;
            initError = t;
        }
        this.container = container;
        this.initError = initError;
    }

    public <T> void run(Class<T> beanType, Consumer<T> action, Consumer<Throwable> errorHandler) {
        if (this.container != null) {
            try {
                Object instance = this.container.instance().select(beanType, new Annotation[0]).get();
                action.accept(instance);
            }
            catch (Throwable t) {
                errorHandler.accept(t);
            }
        } else {
            errorHandler.accept(this.initError);
        }
    }

    public void close() {
        if (this.container != null && this.container.isRunning()) {
            try {
                this.container.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

